//*****************************************************************************
//      Filename : ugHapticModel.h
// ----------------------------------------------------------------------------
//
// By Laehyun Kim
// University of Southern California
//
//*****************************************************************************


#ifndef UGHapticModel_INCLUDE
#define UGHapticModel_INCLUDE

#include "global.h"

#include "cpt/cpt.h"

#include "Lib3D/Camera.h"
#include "Lib3D/Viewport.h"

#define LeftButtonDown	0
#define LeftButtonUp	1
#define RightButtonDown 2
#define RightButtonUp	3

#define NO_TEXTURE		0
#define NOISE_TEXTURE	1
#define PATTERN_TEXTURE 2


// ForceField derived class that represents a sphere with magnetic
// attraction.
class ugHapticModel 
{
public:
	
    // Constructor.
    ugHapticModel(){ 
		init();
	}

    ugHapticModel(int gsize, float mR){ 
		gridSize = gsize;
		maxDRate = mR;
		init();
	}
    ~ugHapticModel() { cleanup(); }

	void init();
	void cleanup();


	// cpt
	int loadCPT(char *fname);
	void drawCPT();

	void loadIVFile(char *fname);
	void drawObject();

	// get/set the grid size
	float getGridSize() { return gridSize; }
	void  setGridSize(int gs) { 
			  if( gs == gridSize ) return;
			  else gridSize = gs;

			  reGridSize();
	}

	int setTextureType( int type );
	int getTextureType() { return textureType; }

	void setShowMesh( bool smesh ) { meshMode = smesh; }
	bool getShowMesh() { return meshMode; }
	
	// get/set the rate of maximum distancefor potential value
	float getMaxDistRate() { return maxDRate; }
	void  setMaxDistRate(float mR) { maxDRate = mR; }

	int  m_Mode;

	CMesh3d* GetMesh() { return &theMesh; }

	// view
	void initView(int width, int height);
	void updateView();
	void onSize(int width, int height);

	// arc ball
	void mouseMove(int x, int y);
	void handleMouseButton(int x, int y, int status);

	void setFlatShading() { flatShading = true; }
	bool isFlatShading() { return flatShading; }


private:

    bool read_polygon, meshMode, flatShading;
	bool LButtonDn, RButtonDn;

	CMesh3d	  theMesh;
	CCamera   theCamera;
	CViewport theViewport;
	CArcball  theArcball;

	int  textureType;

	void reGridSize();

};

#endif
