//-----------------------------------------------------------------------------
// Sean Mauch
// 11/3/99
// util.h
// Utility functions
//-----------------------------------------------------------------------------

#ifndef _Util_
#define _Util_

#include <iosfwd>
#include <vector>

using namespace std;


//---------------------------The Double Class--------------------------------

template<class T>
class Double {
private:
  T the_data[2];
  
  void copy ( const Double& d )
  {
    the_data[0] = (d.the_data)[0];
    the_data[1] = (d.the_data)[1];
  }
  
public:
  
  //----------------------------Constructors, etc.----------------------------
  
  // Default Constructor
  Double ( void )
  {
  }
  
  // Construct from two elements.
  Double ( const T& a, const T& b )
  {
    the_data[0] = a;
    the_data[1] = b;
  }
  
  // Copy Constructor
  Double ( const Double& d )
  {
    copy( d );
  }
  
  // Trivial Destructor
  ~Double ()
  {
  }
  
  // Assignment operator
  Double operator = ( const Double& d )
  {
    copy( d );
    return *this;
  }

  //----------------------------Accessors------------------------------------

  T& operator[] ( int i )
  {
    // assert( 0 <= i && i < 2 );
    return the_data[i];
  }

  const T& operator[] ( int i ) const
  {
    // assert( 0 <= i && i < 2 );
    return the_data[i];
  }
};


//-----------------------------Equality------------------------------------

template<class T>
int
operator == ( const Double<T>& a, const Double<T>& b )
{
  return ( a[0] == b[0] && a[1] == b[1] );
}

template<class T>
int
operator != ( const Double<T>& a, const Double<T>& b )
{
  return !( a == b );
}

//---------------------------The Triple Class--------------------------------

template<class T>
class Triple {
private:
  T the_data[3];
  
  void copy ( const Triple& t )
  {
    the_data[0] = (t.the_data)[0];
    the_data[1] = (t.the_data)[1];
    the_data[2] = (t.the_data)[2];
  }
  
public:
  
  //----------------------------Constructors, etc.----------------------------
  
  // Default Constructor
  Triple ( void )
  {
  }
  
  // Construct from three elements.
  Triple ( const T& a, const T& b, const T& c )
  {
    the_data[0] = a;
    the_data[1] = b;
    the_data[2] = c;
  }
  
  // Copy Constructor
  Triple ( const Triple& t )
  {
    copy( t );
  }
  
  // Trivial Destructor
  ~Triple ()
  {
  }
  
  // Assignment operator
  Triple operator = ( const Triple& t )
  {
    copy( t );
    return *this;
  }

  //----------------------------Accessors------------------------------------

  T& operator[] ( int i )
  {
    // assert( 0 <= i && i < 3 );
    return the_data[i];
  }

  const T& operator[] ( int i ) const
  {
    // assert( 0 <= i && i < 3 );
    return the_data[i];
  }
};

//-----------------------------Equality------------------------------------

template<class T>
int
operator == ( const Triple<T>& a, const Triple<T>& b )
{
  return ( a[0] == b[0] && a[1] == b[1] && a[2] == b[2] );
}

template<class T>
int
operator != ( const Triple<T>& a, const Triple<T>& b )
{
  return !( a == b );
}


//---------------------------Set operations-----------------------------------

template<class T>
int set_in( const T& elem, const vector<T>& s )
{
  typename vector<T>::const_iterator end = s.end();
  typename vector<T>::const_iterator iter = s.begin();
  for ( ; iter != end; ++iter )
    if ( elem == (*iter) )
      return 1;
  return 0;
}


template<class T>
int set_subset( const vector<T>& a, const vector<T>& b )
{
  if ( a.size() > b.size() )
    return 0;
  typename vector<T>::const_iterator end = a.end();
  typename vector<T>::const_iterator iter = a.begin();
  for ( ; iter != end; ++iter )
    if ( ! set_in( (*iter), b ) )
      return 0;
  return 1;
}

template<class T>
int set_equal( const vector<T>& a, const vector<T>& b )
{
  return ( set_subset( a, b ) && set_subset( b, a ) );
}


template<class T>
ostream& operator << ( ostream& out, const vector<T>& v )
{
  typename vector<T>::const_iterator end = v.end();
  typename vector<T>::const_iterator iter = v.begin();
  for ( ; iter != end; ++iter )
    out << (*iter) << endl;
  return out;
}

#endif // _Util_

