// -*- C++ -*-
//----------------------------------------------------------------------
//
//                         Michael Aivazis
//                California Institute of Technology
//                   (C) 2000 All Rights Reserved
//
//----------------------------------------------------------------------

// $Log: f77_bindings.h,v $
// Revision 1.5  2000/08/23 20:22:44  aivazis
// Added F77EXTERNS_LOWERCASE_TRAILINGBAR section
//
// Revision 1.4  2000/08/17 23:51:06  aivazis
// Repaired the FORTRAN bindings
//
// Revision 1.3  2000/04/28 18:57:52  aivazis
// Removed an extra trailing bar
//
// Revision 1.2  2000/04/27 19:51:58  aivazis
// Added another translation section
//
// Revision 1.1  2000/04/10 18:31:46  aivazis
// Original source
//

// This file takes care of the names that FORTRAN programs see
// The build procedure defined NEEDS_F77_TRANSLATION for every platform
// that has a non-standard naming convention and then specifies what translation
// to perform

#if !defined(NEEDS_F77_TRANSLATION)
#define cpt_init_parameters_f     cpt_init_parameters_f_
#define cpt_init_grid_f           cpt_init_grid_f_
#define cpt_init_brep_f           cpt_init_brep_f_
#define cpt_f                     cpt_f_
#define cpt_bbox_f                cpt_bbox_f_
#define cpt_find_sign_distance_f  cpt_find_sign_distance_f_
#define oriented_surface_f        oriented_surface_f_
#define orient_surface_f          orient_surface_f_
#define cpt_write_state_f         cpt_write_state_f_
#define cpt_transpose_int_f       cpt_transpose_int_f_
#define cpt_transpose_real_f      cpt_transpose_real_f_

#else // NEEDS_F77_TRANSLATION

#if defined(F77EXTERNS_NOTRAILINGBAR)

/* 
   This is how these symbols are defined here. No translation is necessary
*/

#elif defined(F77EXTERNS_LOWERCASE_TRAILINGBAR)

#define cpt_init_parameters_f     cpt_init_parameters_f_
#define cpt_init_grid_f           cpt_init_grid_f_
#define cpt_init_brep_f           cpt_init_brep_f_
#define cpt_f                     cpt_f_
#define cpt_bbox_f                cpt_bbox_f_
#define cpt_find_sign_distance_f  cpt_find_sign_distance_f_
#define oriented_surface_f        oriented_surface_f_
#define orient_surface_f          orient_surface_f_
#define cpt_write_state_f         cpt_write_state_f_
#define cpt_transpose_int_f       cpt_transpose_int_f_
#define cpt_transpose_real_f      cpt_transpose_real_f_


#elif defined(F77EXTERNS_UPPERCASE_NOTRAILINGBAR)

#define cpt_init_parameters_f     CPT_INIT_PARAMETERS_F
#define cpt_init_grid_f           CPT_INIT_GRID_F
#define cpt_init_brep_f           CPT_INIT_BREP_F
#define cpt_f                     CPT_F
#define cpt_bbox_f                CPT_BBOX_F
#define cpt_find_sign_distance_f  CPT_FIND_SIGN_DISTANCE_F
#define oriented_surface_f        ORIENTED_SURFACE_F
#define orient_surface_f          ORIENT_SURFACE_F
#define cpt_write_state_f         CPT_WRITE_STATE_F
#define cpt_transpose_int_f       CPT_TRANSPOSE_INT_F
#define cpt_transpose_real_f      CPT_TRANSPOSE_REAL_F

#elif defined(F77EXTERNS_COMPAQ_F90)

#define cpt_init_parameters_f     cpt_init_parameters_f__
#define cpt_init_grid_f           cpt_init_grid_f__
#define cpt_init_brep_f           cpt_init_brep_f__
#define cpt_f                     cpt_f__
#define cpt_bbox_f                cpt_bbox_f__
#define cpt_find_sign_distance_f  cpt_find_sign_distance_f__
#define oriented_surface_f        oriented_surface_f__
#define orient_surface_f          orient_surface_f__
#define cpt_write_state_f         cpt_write_state_f__
#define cpt_transpose_int_f       cpt_transpose_int_f__
#define cpt_transpose_real_f      cpt_transpose_real_f__


#else

#error Uknown translation for FORTRAN external symbols

#endif

#endif // NEEDS_F77_TRANSLATION

//
// End of file
