// -*- C++ -*-
//----------------------------------------------------------------------
//
//                            Sean Mauch
//                California Institute of Technology
//                   (C) 2000 All Rights Reserved
//
//----------------------------------------------------------------------

// $Log: cpt_defs.h,v $
// Revision 1.8  2001/01/07 03:15:51  sean
// Made HUGE stand for unknown.
//
// Revision 1.7  2000/08/15 00:00:07  aivazis
// Added include <new>. For new
//
// Revision 1.6  2000/07/28 19:44:08  sean
// Added CPT_FACE_BBOX.
//
// Revision 1.5  2000/06/22 22:52:08  sean
// Used #ifdef CPT_BREP_IO to get rid of some IO.  Perhaps more portable.
//
// Revision 1.4  2000/06/19 12:37:57  sean
// Added CPT_ to TIMING and VERBOSE
//
// Revision 1.3  2000/05/18 15:46:21  sean
// Added doxygen style documentation.
//
// Revision 1.2  2000/04/05 11:28:56  sean
// *** empty log message ***
//
// Revision 1.1  2000/03/20 16:05:36  sean
// *** empty log message ***
//

/*! 
  \file cpt_defs.h
  \brief Specify options for the closest point transform.
*/

#if !defined(__Defs_h__)
#define __Defs_h__

//! Choose single or double precision.
//typedef double Real;
typedef float Real;

// Turn off debugging.  So that assert's are ignored.
// #define NDEBUG

// Verbose mode.  Print progress information to stdout.
//#define CPT_VERBOSE

// Whether to print timing information to stdout.
//#define CPT_TIMING

// Whether to have IO functions for BRep.
//#define CPT_BREP_IO

// Print the grid info the the BRep in a file that the driver can read.
//#define PRINT_DRIVER_INPUT

// The following options print the object in a format that Mathematica can
// read.
//#define MATHEMATICA_PRINT_BREP
//#define MATHEMATICA_PRINT_FACE_POLYHEDRA
//#define MATHEMATICA_PRINT_EDGE_POLYHEDRA
//#define MATHEMATICA_PRINT_VERTEX_POLYHEDRA

//! Use the BBox scan conversion for faces.
#define CPT_FACE_BBOX

#include <new>

#endif

//
// End of file
