// -*- C++ -*-
//----------------------------------------------------------------------
//
//                            Sean Mauch
//                California Institute of Technology
//                   (C) 1999 All Rights Reserved
//
//----------------------------------------------------------------------

// $Log: Polygon.ipp,v $
// Revision 1.3  2000/06/26 08:24:31  sean
// Now return const references instead of objects for accessors.
//
// Revision 1.2  2000/03/20 16:01:55  sean
// *** empty log message ***
//
// Revision 1.1  1999/11/28 06:25:13  sean
// Split code for classes into .h, .ipp and .cc files.
//

#if !defined(__cptPolygon_inl__)
#error This file is an implementation detail of the class cptPolygon
#endif

// Inline method definitions

//---------------------------------Accesors---------------------------------

inline
int 
cptPolygon::size ( void ) const 
{
  return _vertices.size();
}

inline
const Point2&
cptPolygon::vertex( int i ) const 
{
  //  assert( 0 <= i && i < int( _vertices.size() ) );
  return _vertices[i];
}

inline
Point2& 
cptPolygon::vertex( int i ) 
{
  //  assert( 0 <= i && i < int( _vertices.size() ) );
  return _vertices[i];
}

inline
void 
cptPolygon::push_back( const Point2& p ) 
{
  _vertices.push_back( p );
}

inline
void 
cptPolygon::insert( int i, const Point2& p ) 
{
  assert( 0 <= i && i < int( _vertices.size() ) );
  _vertices.insert( _vertices.begin() + i, p );
}

inline
void 
cptPolygon::erase ( int i ) 
{
  assert( 0 <= i && i < int( _vertices.size() ) );
  _vertices.erase( _vertices.begin() + i );
}

inline
// Clear the Polygon.  Remove all the vertices.
void 
cptPolygon::clear ( void ) 
{
  _vertices.clear();
}


//
// End of file
