// -*- C++ -*-
//----------------------------------------------------------------------
//
//                            Sean Mauch
//                California Institute of Technology
//                   (C) 1999 All Rights Reserved
//
//----------------------------------------------------------------------

// $Log: cptPolygon.h,v $
// Revision 1.5  2000/06/27 03:49:42  sean
// Added scan_convert_triangle() to speed up scan conversion
//
// Revision 1.4  2000/06/26 08:24:31  sean
// Now return const references instead of objects for accessors.
//
// Revision 1.3  2000/04/05 21:33:12  sean
// Changed iostream.h to iostream.
//
// Revision 1.2  2000/03/20 16:00:53  sean
// *** empty log message ***
//
// Revision 1.1  1999/11/28 06:25:13  sean
// Split code for classes into .h, .ipp and .cc files.
//

#if !defined(__cptPolygon_h__)
#define __cptPolygon_h__

#include "cpt_defs.h"

#include <iosfwd>
#include <vector>

#include "Point2.h"
#include "Coord.h"
#include "CyclicIndex.h"
#include "Grid.h"

using namespace std;


// A cptPolygon is a list of vertices that are ordered in the positive, 
// ( counter-clockwise ), direction.  The edges have outward normals.
class cptPolygon
{
public:

  cptPolygon();
  cptPolygon( int s );
  cptPolygon( const cptPolygon& rhs );
  
  // modified by LHK(04/20/2001)
  const cptPolygon& operator=( const cptPolygon& rhs );
  
  virtual ~cptPolygon();

  //---------------------------------Accesors---------------------------------
  int size ( void ) const;
  const Point2& vertex( int i ) const;
  Point2& vertex( int i );
  void push_back( const Point2& p );
  void insert( int i, const Point2& p );
  void erase ( int i );
  void clear ( void );
 
  //----------------------Mathematical operations-----------------------------
  void order( void );
  void remove_duplicates( void );
  int bottom_and_top( Real& bottom, Real& top ) const;
  void scan_convert_triangle( vector<Coord>& , const Grid&, const int ) const;
  void scan_convert( vector<Coord>& , const Grid&, const int ) const;
  int check ( void ) const;
  
  //-----------------------------IO----------------------------------------
  void mathematica_print( void ) const;
  
protected:
  
private:

  vector<Point2> _vertices;
  
  void copy ( const cptPolygon& poly );

};

//--------------------------------File IO------------------------------------
//istream& operator >> ( istream& in, cptPolygon& poly );
//ostream& operator << ( ostream& out, const cptPolygon& poly );


#define __cptPolygon_inl__
#include "cptPolygon.inl"
#undef __cptPolygon_inl__

#endif

//
// End of file
