// -*- C++ -*-
//----------------------------------------------------------------------
//
//                            Sean Mauch
//                California Institute of Technology
//                   (C) 1999 All Rights Reserved
//
//----------------------------------------------------------------------

// $Log: Vertex.ipp,v $
// Revision 1.5  2000/06/26 08:24:31  sean
// Now return const references instead of objects for accessors.
//
// Revision 1.4  2000/03/20 16:01:55  sean
// *** empty log message ***
//
// Revision 1.3  2000/02/24 09:02:13  sean
// Added closest face capability.
//
// Revision 1.2  1999/12/30 22:50:35  sean
// Added accessor to edge_directions.
//
// Revision 1.1  1999/11/28 06:25:13  sean
// Split code for classes into .h, .ipp and .cc files.
//

#if !defined(__Vertex_inl__)
#error This file is an implementation detail of the class Vertex
#endif

// Inline method definitions

//--------------------------Accessors--------------------------------------

inline
const Point& 
Vertex::point( void ) const
{
  return _point;
}

inline
int 
Vertex::sign_distance( void ) const
{
  return _sign_distance;
}

// Return true if the surface is convex or concave at the vertex.
inline
int 
Vertex::convex_or_concave( void ) const
{
  return (_sign_distance * _sign_distance);
}

inline
const vector<Point>& 
Vertex::normals( void ) const
{
  return _normals;
}

inline
const vector<Point>& 
Vertex::edge_directions( void ) const
{
  return _edge_directions;
}

inline
const Point&
Vertex::normal( int i ) const
{
  //  assert( 0 <= i && i < int( _normals.size() ) );
  return _normals[i];
}

inline
int 
Vertex::adjacent_face_index( void ) const
{
  return _adjacent_face_index;
}

//
// End of file
