// -*- C++ -*-
//----------------------------------------------------------------------
//
//                            Sean Mauch
//                California Institute of Technology
//                   (C) 2000 All Rights Reserved
//
//----------------------------------------------------------------------

// $Log: Vertex.h,v $
// Revision 1.10  2000/09/17 08:22:19  sean
// Added the gradient of the distance to the computed arrays.
//
// Revision 1.9  2000/06/26 08:24:31  sean
// Now return const references instead of objects for accessors.
//
// Revision 1.8  2000/06/16 23:11:52  sean
// Changed includes.
//
// Revision 1.7  2000/04/05 11:26:29  sean
// Deleted #include <math.h>
//
// Revision 1.6  2000/03/20 16:01:55  sean
// *** empty log message ***
//
// Revision 1.5  2000/03/09 11:10:12  sean
// Took out inside Polyhedron checking to speed up.
//
// Revision 1.4  2000/03/08 11:46:48  sean
// Changed comments.
//
// Revision 1.3  2000/02/24 09:02:13  sean
// Added closest face capability.
//
// Revision 1.2  1999/12/30 22:49:56  sean
// Added accessor to edge_directions.
//
// Revision 1.1  1999/11/28 06:25:13  sean
// Split code for classes into .h, .ipp and .cc files.
//

#if !defined(__Vertex_h__)
#define __Vertex_h__

#include "cpt_defs.h"

#include <vector>

#include "Point.h"

using namespace std;

class Vertex
{
public:

  Vertex();
  Vertex( const Point&, const vector<Point>&, const vector<Point>&, 
	  const int );
  Vertex( const Vertex& rhs );
  const Vertex& operator=( const Vertex& rhs );
  void make( const Point&, const vector<Point>&, const vector<Point>&, 
	     const int );
  
  virtual ~Vertex();

  //--------------------------Accessors--------------------------------------
  const Point& point( void ) const;
  int sign_distance( void ) const;
  int convex_or_concave( void ) const;
  const vector<Point>& normals( void ) const;
  const vector<Point>& edge_directions( void ) const;
  const Point& normal( int i ) const;
  int adjacent_face_index( void ) const;

  //----------------------Mathematical operations-----------------------------
  Real distance( const Point& ) const;
  int distance( const Point&, Real& ) const;
  Point grad_distance( const Point& cart_pt ) const;
  
protected:
  
private:

  // The location of the vertex.
  Point _point;

  // The points that are closest to the vertex lie in a pyramid.
  // The normals to the sides of the pyramid.
  vector<Point> _normals;

  // The edge directions of the pyramid.
  vector<Point> _edge_directions;

  // The sign of the distance.
  int _sign_distance;
  
  // The index of an adjacent face.
  int _adjacent_face_index;

  void copy( const Vertex& v );

};

#define __Vertex_inl__
#include "Vertex.inl"
#undef __Vertex_inl__

#endif

//
// End of file
