// -*- C++ -*-
//----------------------------------------------------------------------
//
//                            Sean Mauch
//                California Institute of Technology
//                   (C) 1999 All Rights Reserved
//
//----------------------------------------------------------------------

// $Log: Triangle.h,v $
// Revision 1.3  2000/06/26 08:24:31  sean
// Now return const references instead of objects for accessors.
//
// Revision 1.2  2000/03/20 16:01:55  sean
// *** empty log message ***
//
// Revision 1.1  1999/11/28 06:25:13  sean
// Split code for classes into .h, .ipp and .cc files.
//

#if !defined(__Triangle_h__)
#define __Triangle_h__

#include "cpt_defs.h"

#include "Point.h"
#include "Plane.h"

using namespace std;

class Triangle
{
public:

  Triangle();
  Triangle( const Point& a, const Point& b, const Point& c );
  Triangle( const Triangle& rhs );
  const Triangle& operator=( const Triangle& rhs );
  
  virtual ~Triangle();

  //-----------------------------Accesors-------------------------------------
  const Point& vertex( int i ) const;
  Point& vertex( int i );

  //-------------------------Point arithmetic---------------------------------
  Triangle& operator += ( const Point& p );
  Triangle& operator -= ( const Point& p );

  //----------------------Mathematical operations-----------------------------
  Plane supporting_plane( void ) const;
  
protected:
  
private:

  Point _vertices[3];

  void copy( const Triangle& t );
};

//-------------------------------File IO------------------------------------
//istream& operator >> ( istream& in, Triangle& t );
//ostream& operator << ( ostream& out, const Triangle& t );


#define __Triangle_inl__
#include "Triangle.inl"
#undef __Triangle_inl__

#endif

//
// End of file
