// -*- C++ -*-
//----------------------------------------------------------------------
//
//                            Sean Mauch
//                California Institute of Technology
//                   (C) 1999 All Rights Reserved
//
//----------------------------------------------------------------------

// $Log: Segment.ipp,v $
// Revision 1.2  2000/06/26 08:24:31  sean
// Now return const references instead of objects for accessors.
//
// Revision 1.1  1999/11/28 06:25:13  sean
// Split code for classes into .h, .ipp and .cc files.
//

#if !defined(__Segment_inl__)
#error This file is an implementation detail of the class Component
#endif

// Inline method definitions


//---------------------------------Accesors--------------------------------

inline
const Point&
Segment::source() const 
{
  return _source;
}

inline
Point& 
Segment::source() 
{
  return _source;
}

inline
const Point&
Segment::target() const 
{
  return _target;
}

inline
Point& 
Segment::target() 
{
  return _target;
}

//-----------------------------Equality Relations---------------------------

inline 
int 
operator == ( const Segment& s, const Segment& t )
{
  return ( s.source() == t.source() && s.target() == t.target() );
}

inline 
int 
operator != ( const Segment& s, const Segment& t )
{
  return ( s.source() != t.source() || s.target() != t.target() );
}

//---------------------------Mathematical Functions--------------------------

// Positive
inline
Segment
operator + ( const Segment& s )
{
  return s;
}

// Negative
inline
Segment
operator - ( const Segment& s )
{
  return Segment( s.target(), s.source() );
}

// Addition
inline
Segment
operator + ( const Segment& s, const Point& p )
{
  return Segment( s.source() + p, s.target() + p );
}

// Subtraction
inline
Segment
operator - ( const Segment& s, const Point& p )
{
  return Segment( s.source() - p, s.target() - p );
}


//
// End of file
