// -*- C++ -*-
//----------------------------------------------------------------------
//
//                            Sean Mauch
//                California Institute of Technology
//                   (C) 1999 All Rights Reserved
//
//----------------------------------------------------------------------

// $Log: Segment.h,v $
// Revision 1.4  2000/07/03 23:34:11  sean
// Added make().
//
// Revision 1.3  2000/06/26 08:24:31  sean
// Now return const references instead of objects for accessors.
//
// Revision 1.2  2000/03/20 16:01:55  sean
// *** empty log message ***
//
// Revision 1.1  1999/11/28 06:25:13  sean
// Split code for classes into .h, .ipp and .cc files.
//

#if !defined(__Segment_h__)
#define __Segment_h__

#include "cpt_defs.h"

#include "Point.h"

using namespace std;

class Segment
{
public:

  Segment();
  Segment ( Real x1, Real y1, Real z1, Real x2, Real y2, Real z2 );
  Segment ( const Point& source, const Point& target );
  
  Segment(const Segment& rhs);
  const Segment& operator=(const Segment& rhs);
  void make( const Point& source, const Point& target );
  
  virtual ~Segment();

  //---------------------------------Accesors--------------------------------
  const Point& source() const;
  Point& source();
  const Point& target() const;
  Point& target();

  //-------------------------------Arithmetic---------------------------------
  Segment& operator += ( const Point& p );
  Segment& operator -= ( const Point& p );

  //------------------------Mathematical operations---------------------------
  Real length ( void ) const;
  Point tangent ( void ) const;
  Real closest_point( const Point& p, Point& cp ) const;
  int z_intersect( Real& x, Real& y, const Real z ) const;
  
protected:
  
private:

  Point _source, _target;
  
  void copy ( const Segment& s );

};



//-----------------------------Equality Relations---------------------------
int operator == ( const Segment& s, const Segment& t );
int operator != ( const Segment& s, const Segment& t );

//---------------------------Mathematical Functions--------------------------
Segment operator + ( const Segment& s );
Segment operator - ( const Segment& s );
Segment operator + ( const Segment& s, const Point& p );
Segment operator - ( const Segment& s, const Point& p );

//-----------------------Input/Ouput-----------------------------------------
//istream& operator >> ( istream& in, Segment& s );
//ostream& operator << ( ostream& out, Segment& s );



#define __Segment_inl__
#include "Segment.inl"
#undef __Segment_inl__

#endif

//
// End of file
