// -*- C++ -*-
//----------------------------------------------------------------------
//
//                            Sean Mauch
//                California Institute of Technology
//                   (C) 1999 All Rights Reserved
//
//----------------------------------------------------------------------

// $Log: Polyhedron.h,v $
// Revision 1.10  2000/07/03 23:35:03  sean
// New add_edge().
//
// Revision 1.9  2000/06/30 23:39:53  sean
// Do cart_to_grid() as the polyhedra are made.
//
// Revision 1.8  2000/06/16 23:09:38  sean
// Changed includes.
//
// Revision 1.7  2000/04/05 21:33:12  sean
// Changed iostream.h to iostream.
//
// Revision 1.6  2000/03/20 16:01:55  sean
// *** empty log message ***
//
// Revision 1.5  2000/03/09 11:10:12  sean
// Took out inside Polyhedron checking to speed up.
//
// Revision 1.4  2000/03/08 11:45:47  sean
// Improved making Polyhedron from a Vertex.
//
// Revision 1.3  2000/02/24 09:01:13  sean
// Fixed the make() function.
//
// Revision 1.2  1999/12/30 22:46:41  sean
// Changed mathematica_print to print to an ostream.
//
// Revision 1.1  1999/11/28 06:25:13  sean
// Split code for classes into .h, .ipp and .cc files.
//

#if !defined(__Polyhedron_h__)
#define __Polyhedron_h__

#include "cpt_defs.h"

#include <iosfwd>
#include <vector>

#include "Point.h"
#include "Segment.h"
#include "cptPolygon.h"
#include "BBox.h"
#include "Vertex.h"
#include "Edge.h"
#include "Face.h"

using namespace std;

class Polyhedron
{
public:

  Polyhedron();
  Polyhedron( const Polyhedron& rhs );
  const Polyhedron& operator=( const Polyhedron& rhs );
  
  virtual ~Polyhedron();

  //--------------------------Mathematical Member Functions-------------------
  void make ( const Vertex&, Real );
  void make ( const Vertex&, Real, const Grid& );
  void make ( const Edge&, Real );
  void make ( const Edge&, Real, const Grid& );
  void make ( const Face&, Real );
  void make ( const Face&, Real, const Grid& );
  int scan_convert_bbox( vector<Coord>& cs, const Grid& grid ) const;
  void z_intersect( cptPolygon&, Real );
  int scan_convert( vector<Coord>& cs, const Grid& grid );
  //----------------------------------Accessors-------------------------------
  const vector<Segment>& edges ( void ) const;
   //-------------------------------IO---------------------------------------
  void mathematica_print( ostream& );

protected:
  
private:

  vector<Segment> _edges;

  void copy( const Polyhedron& p );
  void add_edge( const Point& p, const Point& q );
  void add_edge( Segment& seg, const Point& p, const Point& q );
};

//----------------------------Utility Functions------------------------------
Point offset_outward( const Point& n1, const Point& n2, Real delta );

#define __Polyhedron_inl__
#include "Polyhedron.inl"
#undef __Polyhedron_inl__

#endif

//
// End of file
