// -*- C++ -*-
//----------------------------------------------------------------------
//
//                            Sean Mauch
//                California Institute of Technology
//                   (C) 1999 All Rights Reserved
//
//----------------------------------------------------------------------

// $Log: Point2.ipp,v $
// Revision 1.3  2000/06/26 08:24:31  sean
// Now return const references instead of objects for accessors.
//
// Revision 1.2  2000/03/20 16:00:53  sean
// *** empty log message ***
//
// Revision 1.1  1999/11/28 06:25:13  sean
// Split code for classes into .h, .ipp and .cc files.
//

#if !defined(__Point2_inl__)
#error This file is an implementation detail of the class Component
#endif

// Inline method definitions

//-----------------------------Accesors-------------------------------------
inline
Real Point2::x() const {
  return _x;
}

inline
Real Point2::y() const {
  return _y;
}

inline
Real& Point2::x() {
  return _x;
}

inline
Real& Point2::y() {
  return _y;
}


//--------------------------Mathematical Operations---------------------------

// Positive
inline
Point2
operator + ( const Point2& p ) 
{
  return p;
}

// Negative
inline
Point2
operator - ( const Point2& p ) 
{
  return Point2( -p.x(), -p.y() );
}

// Addition
inline
Point2
operator + ( const Point2& p, const Point2& q )
{
  return Point2( p.x() + q.x(), p.y() + q.y() );
}

// Subtraction
inline
Point2
operator - ( const Point2& p, const Point2& q )
{
  return Point2( p.x() - q.x(), p.y() - q.y() );
}

// Multiplication
inline
Point2
operator * ( const Point2& p, Real val )
{
  return Point2( p.x() * val, p.y() * val );
}

// Multiplication
inline
Point2
operator * ( Real val, const Point2& p )
{
  return Point2( p.x() * val, p.y() * val );
}

// Division
inline
Point2
operator / ( const Point2& p, Real val )
{
  return Point2( p.x() / val, p.y() / val );
}

// Equality relations
inline 
int 
operator == ( const Point2& p, const Point2& q )
{
  return ( p.x() == q.x() && p.y() == q.y() );
}

inline 
int 
operator != ( const Point2& p, const Point2& q )
{
  return ( p.x() != q.x() || p.y() != q.y() );
}



//
// End of file
