// -*- C++ -*-
//----------------------------------------------------------------------
//
//                            Sean Mauch
//                California Institute of Technology
//                   (C) 1999 All Rights Reserved
//
//----------------------------------------------------------------------

// $Log: Point2.h,v $
// Revision 1.7  2000/07/03 23:34:11  sean
// Added make().
//
// Revision 1.6  2000/06/26 08:24:31  sean
// Now return const references instead of objects for accessors.
//
// Revision 1.5  2000/06/16 23:08:43  sean
// Changed includes.
//
// Revision 1.4  2000/04/05 21:33:12  sean
// Changed iostream.h to iostream.
//
// Revision 1.3  2000/04/05 11:25:16  sean
// Deleted #include <math.h>
//
// Revision 1.2  2000/03/20 16:01:55  sean
// *** empty log message ***
//
// Revision 1.1  1999/11/28 06:25:13  sean
// Split code for classes into .h, .ipp and .cc files.
//

#if !defined(__Point2_h__)
#define __Point2_h__

#include "cpt_defs.h"

#include <iosfwd>

using namespace std;

class Point2
{
public:

  Point2();
  Point2( Real x, Real y );
  Point2(const Point2 & rhs);
  const Point2 & operator=(const Point2& rhs);
  void make( Real x, Real y );
  
  virtual ~Point2();

  //-----------------------------Accesors-------------------------------------
  Real x() const;
  Real y() const;
  Real& x();
  Real& y();

  //-------------------------Point arithmetic---------------------------------
  Point2& operator += ( const Point2& p );
  Point2& operator -= ( const Point2& p );
  Point2& operator *= ( Real val );
  Point2& operator /= ( Real val );

  //----------------------Mathematical operations-----------------------------
  Real magnitude ( void );
  Point2& normalize ( void );
  Point2& rotpio2 ( void );
  Point2& rotmpio2 ( void );

protected:
  
private:
  Real _x, _y;  

  void copy( const Point2& p );
};


//--------------------------Mathematical Operations---------------------------
Point2 operator + ( const Point2& p );
Point2 operator - ( const Point2& p );
Point2 operator + ( const Point2& p, const Point2& q );
Point2 operator - ( const Point2& p, const Point2& q );
Point2 operator * ( const Point2& p, Real val );
Point2 operator * ( Real val, const Point2& p );
Point2 operator / ( const Point2& p, Real val );
int operator == ( const Point2& p, const Point2& q );
int operator != ( const Point2& p, const Point2& q );

//-----------------------------File IO----------------------------------------
//istream& operator >> ( istream& in, Point2& p );
//ostream& operator << ( ostream& out, const Point2& p );

//-------------------------Mathematical operations----------------------------
Real point_distance ( const Point2& p, const Point2& q );
Real dot ( const Point2& p, const Point2& q );
Real discriminant( const Point2& p, const Point2& q );
int positiveTurn( const Point2& p, const Point2& q, const Point2& r );
int approxPositiveTurn( const Point2& p, const Point2& q, const Point2& r );
Real pseudo_angle( const Point2& p, const Point2& q );


#define __Point2_inl__
#include "Point2.inl"
#undef __Point2_inl__

#endif

//
// End of file
