// -*- C++ -*-
//----------------------------------------------------------------------
//
//                            Sean Mauch
//                California Institute of Technology
//                   (C) 1999 All Rights Reserved
//
//----------------------------------------------------------------------

// $Log: Point.ipp,v $
// Revision 1.7  2001/01/07 22:01:27  sean
// Removed isnap().
//
// Revision 1.6  2001/01/07 03:15:51  sean
// Made HUGE stand for unknown.
//
// Revision 1.5  2000/06/26 08:24:31  sean
// Now return const references instead of objects for accessors.
//
// Revision 1.4  2000/06/16 23:07:55  sean
// Changed includes.
//
// Revision 1.3  2000/03/20 16:00:53  sean
// *** empty log message ***
//
// Revision 1.2  1999/12/03 01:18:54  sean
// Change floats like 0.f to doubles like 0.0.
//
// Revision 1.1  1999/11/28 06:25:13  sean
// Split code for classes into .h, .ipp and .cc files.
//

#if !defined(__Point_inl__)
#error This file is an implementation detail of the class Component
#endif

#include <cassert>
#include <cmath>

// Inline method definitions

//-----------------------------Accesors-------------------------------------

inline
Real Point::x() const {
  return _x;
}

inline
Real Point::y() const {
  return _y;
}

inline
Real Point::z() const {
  return _z;
}

inline
Real& Point::x() {
  return _x;
}

inline
Real& Point::y() {
  return _y;
}

inline
Real& Point::z() {
  return _z;
}

//--------------------------Mathematical Operations---------------------------

// Positive
inline
Point operator + ( const Point& p ) 
{
  return p;
}

// Negative
inline
Point operator - ( const Point& p ) 
{
  return Point( -p.x(), -p.y(), -p.z() );
}

// Addition
inline
Point operator + ( const Point& p, const Point& q )
{
  return Point( p.x() + q.x(), p.y() + q.y(), p.z() + q.z() );
}

// Subtraction
inline
Point operator - ( const Point& p, const Point& q )
{
  return Point( p.x() - q.x(), p.y() - q.y(), p.z() - q.z() );
}

// Multiplication
inline
Point operator * ( const Point& p, Real val )
{
  return Point( p.x() * val, p.y() * val, p.z() * val );
}

// Multiplication
inline
Point operator * ( Real val, const Point& p )
{
  return Point( p.x() * val, p.y() * val, p.z() * val );
}

// Division
inline
Point operator / ( const Point& p, Real val )
{
  assert( val != 0.0 );
  return Point( p.x() / val, p.y() / val, p.z() / val );
}

// Equality relations
inline 
int operator == ( const Point& p, const Point& q )
{
  return ( p.x() == q.x() && p.y() == q.y() && p.z() == q.z() );
}

inline 
int operator != ( const Point& p, const Point& q )
{
  return ( p.x() != q.x() || p.y() != q.y() || p.z() != q.z() );
}


// Euclidean distance between points.
inline
Real
point_distance ( const Point& p, const Point& q )
{
  return (p - q).magnitude();
}

 
// The dot product.
inline
Real
dot ( const Point& p, const Point& q )
{
  return ( p.x() * q.x() + p.y() * q.y() + p.z() * q.z() );
}


// The cross product.
inline
Point
cross ( const Point& p, const Point& q )
{
  return Point( p.y() * q.z() - p.z() * q.y(),
                p.z() * q.x() - p.x() * q.z(),
		p.x() * q.y() - p.y() * q.x() );
}


// The scalar triple product.
inline
Real
triple_product( const Point& p, const Point& q, const Point& r )
{
  return dot( p, cross( q, r ) );
}



//
// End of file
