// -*- C++ -*-
//----------------------------------------------------------------------
//
//                            Sean Mauch
//                California Institute of Technology
//                   (C) 1999 All Rights Reserved
//
//----------------------------------------------------------------------

// $Log: Point.h,v $
// Revision 1.10  2001/01/07 22:00:31  sean
// Removed isnap().
//
// Revision 1.9  2001/01/07 03:15:51  sean
// Made HUGE stand for unknown.
//
// Revision 1.8  2000/07/03 23:34:11  sean
// Added make().
//
// Revision 1.7  2000/06/26 08:24:31  sean
// Now return const references instead of objects for accessors.
//
// Revision 1.6  2000/06/16 23:07:55  sean
// Changed includes.
//
// Revision 1.5  2000/04/05 21:33:12  sean
// Changed iostream.h to iostream.
//
// Revision 1.4  2000/04/05 11:24:02  sean
// Deleted #include <math.h>
//
// Revision 1.3  2000/03/20 16:00:53  sean
// *** empty log message ***
//
// Revision 1.2  2000/02/24 08:59:54  sean
// Made magnitude() const.
//
// Revision 1.1  1999/11/28 06:25:13  sean
// Split code for classes into .h, .ipp and .cc files.
//

#if !defined(__Point_h__)
#define __Point_h__

#include "cpt_defs.h"

#include <iosfwd>

using namespace std;

class Point
{
public:

  Point();
  Point( Real x, Real y, Real z );
  Point(const Point & rhs);
  const Point & operator=(const Point& rhs);
  void make( Real x, Real y, Real z );

  virtual ~Point();

  //-----------------------------Accesors-------------------------------------
  Real x() const;
  Real y() const;
  Real z() const;
  Real& x();
  Real& y();
  Real& z();

  //-------------------------Point arithmetic---------------------------------
  Point& operator += ( const Point& p );
  Point& operator -= ( const Point& p );
  Point& operator *= ( Real val );
  Point& operator /= ( Real val );

  //----------------------Mathematical operations-----------------------------
  Real magnitude ( void ) const;
  Point& normalize ( void );

protected:

private:

  Real _x, _y, _z;

  void copy( const Point& p );

};

//--------------------------Mathematical Operations---------------------------
Point operator + ( const Point& p );
Point operator - ( const Point& p );
Point operator + ( const Point& p, const Point& q );
Point operator - ( const Point& p, const Point& q );
Point operator * ( const Point& p, Real val );
Point operator * ( Real val, const Point& p );
Point operator / ( const Point& p, Real val );
int operator == ( const Point& p, const Point& q );
int operator != ( const Point& p, const Point& q );

//-------------------------------File IO------------------------------------
//istream& operator >> ( istream& in, Point& p );
//ostream& operator << ( ostream& out, const Point& p );

//-------------------------Mathematical operations----------------------------
Real point_distance ( const Point& p, const Point& q );
Real dot ( const Point& p, const Point& q );
Point cross ( const Point& p, const Point& q );
Real triple_product( const Point& p, const Point& q, const Point& r );




#define __Point_inl__
#include "Point.inl"
#undef __Point_inl__

#endif

//
// End of file
