// -*- C++ -*-
//----------------------------------------------------------------------
//
//                            Sean Mauch
//                California Institute of Technology
//                   (C) 1999 All Rights Reserved
//
//----------------------------------------------------------------------

// $Log: Plane.ipp,v $
// Revision 1.2  2000/06/26 08:24:31  sean
// Now return const references instead of objects for accessors.
//
// Revision 1.1  1999/11/28 06:25:13  sean
// Split code for classes into .h, .ipp and .cc files.
//

#if !defined(__Plane_inl__)
#error This file is an implementation detail of the class Plane
#endif

// Inline method definitions

//-------------------------------Accesors-----------------------------------

inline
const Point&
Plane::point() const 
{
  return _point;
}

inline
const Point&
Plane::normal() const 
{
  return _normal;
}

inline
Point& 
Plane::point() 
{
  return _point;
}

inline
Point& 
Plane::normal() 
{
  return _normal;
}


//---------------------------------Arithmetic-------------------------------

// Positive
inline
Plane
operator + ( const Plane& pl )
{
  return pl;
}

// Negative
inline
Plane
operator - ( const Plane& pl )
{
  return Plane( pl.point(), - pl.normal() );
}

//
// End of file
