// -*- C++ -*-
//----------------------------------------------------------------------
//
//                            Sean Mauch
//                California Institute of Technology
//                   (C) 1999 All Rights Reserved
//
//----------------------------------------------------------------------

// $Log: Plane.h,v $
// Revision 1.4  2000/06/26 08:24:31  sean
// Now return const references instead of objects for accessors.
//
// Revision 1.3  2000/03/20 16:00:53  sean
// *** empty log message ***
//
// Revision 1.2  2000/02/24 08:58:01  sean
// Added the make() function.
//
// Revision 1.1  1999/11/28 06:25:13  sean
// Split code for classes into .h, .ipp and .cc files.
//

#if !defined(__Plane_h__)
#define __Plane_h__

#include "cpt_defs.h"

#include "Point.h"

using namespace std;


class Plane
{
public:

  Plane();
  Plane( const Point& pt, const Point& nm );
  Plane( const Point& a, const Point& b, const Point& c );
  Plane( const Plane& rhs );
  const Plane& operator=( const Plane& rhs );
  
  virtual ~Plane();

  int make ( const Point& a, const Point& b, const Point& c );
  
  //-------------------------------Accesors-----------------------------------
  const Point& point() const;
  const Point& normal() const;
  Point& point();
  Point& normal();

  //------------------------Mathematical operations---------------------------
  Plane& operator += ( const Point& p );
  Plane& operator -= ( const Point& p );
  Real distance( const Point& p ) const;
  Real closest_point( const Point& p, Point& cp ) const;
  
protected:
  
private:

  Point _point, _normal;
  
  void copy ( const Plane& pl );
};


//-----------------------------Arithmetic----------------------------------
Plane operator + ( const Plane& pl );
Plane operator - ( const Plane& pl );

//----------------------------Input/Output------------------------------------
//istream& operator >> ( istream& in, Plane& pl );
//ostream& operator << ( ostream& out, const Plane& pl );
 

#define __Plane_inl__
#include "Plane.inl"
#undef __Plane_inl__

#endif

//
// End of file
