// -*- C++ -*-
//----------------------------------------------------------------------
//
//                            Sean Mauch
//                California Institute of Technology
//                   (C) 1999 All Rights Reserved
//
//----------------------------------------------------------------------

// $Log: Face.ipp,v $
// Revision 1.3  2000/06/26 08:24:31  sean
// Now return const references instead of objects for accessors.
//
// Revision 1.2  2000/02/24 08:54:58  sean
// Added closest face capability.
//
// Revision 1.1  1999/11/28 06:25:13  sean
// Split code for classes into .h, .ipp and .cc files.
//

#if !defined(__Face_inl__)
#error This file is an implementation detail of the class Face
#endif

// Inline method definitions

//--------------------------Accessors--------------------------------------

inline
const Point&
Face::vertex ( int i ) const
{
  //  assert( 0 <= i && i < 3 );
  return _vertices[i];
}

inline
const Point&
Face::normal ( void ) const
{
  return _face.normal();
}

inline
const Point&
Face::side_normal ( int i ) const
{
  //  assert( 0 <= i && i < 3 );
  return _sides[i].normal();
}

inline
int 
Face::index( void ) const
{
  return _index;
}


//
// End of file
