// -*- C++ -*-
//----------------------------------------------------------------------
//
//                            Sean Mauch
//                California Institute of Technology
//                   (C) 1999 All Rights Reserved
//
//----------------------------------------------------------------------

// $Log: Face.h,v $
// Revision 1.6  2000/07/28 19:35:53  sean
// Added BBox scan conversion for faces.
//
// Revision 1.5  2000/06/26 08:24:31  sean
// Now return const references instead of objects for accessors.
//
// Revision 1.4  2000/03/20 16:00:53  sean
// *** empty log message ***
//
// Revision 1.3  2000/03/09 11:10:12  sean
// Took out inside Polyhedron checking to speed up.
//
// Revision 1.2  2000/02/24 08:54:58  sean
// Added closest face capability.
//
// Revision 1.1  1999/11/28 06:25:13  sean
// Split code for classes into .h, .ipp and .cc files.
//

#if !defined(__Face_h__)
#define __Face_h__

#include "cpt_defs.h"

#include "Point.h"
#include "Segment.h"
#include "Plane.h"
#include "Grid.h"

using namespace std;


class Face
{
public:

  Face();
  Face( const Point&, const Point&, const Point&, const Point&, const int );
  Face( const Face&);
  const Face& operator=( const Face&);
  void make( const Point&, const Point&, const Point&, const Point&,
	     const int );
  
  virtual ~Face();

  //--------------------------Accessors--------------------------------------
  const Point& vertex( int ) const;
  const Point& normal( void ) const;
  const Point& side_normal( int ) const;
  int index( void ) const;

  //----------------------Mathematical operations-----------------------------
  Real distance( const Point& ) const;
  Real closest_point( const Point&, Point& ) const;
  int distance( const Point&, Real, Real& ) const;
  int closest_point( const Point&, Real, Real&, Point& ) const;
  int scan_convert( vector<Coord>& cs, const Grid& grid, 
		    Real max_distance ) const;

protected:
  
private:

  // CONTINUE: See if I Really need all these.
  Point _vertices[3];
  Segment _edges[3];
  // The supporting plane of the face.
  Plane _face;
  // The three planes which are incident on the three edges and orthogonal
  // to the face.
  Plane _sides[3];

  // The index of this face.
  int _index;

  void copy( const Face& f );

};

#define __Face_inl__
#include "Face.inl"
#undef __Face_inl__

#endif

//
// End of file
