// -*- C++ -*-
//----------------------------------------------------------------------
//
//                            Sean Mauch
//                California Institute of Technology
//                   (C) 1999 All Rights Reserved
//
//----------------------------------------------------------------------

// $Log: Edge.ipp,v $
// Revision 1.3  2000/06/26 08:24:31  sean
// Now return const references instead of objects for accessors.
//
// Revision 1.2  2000/02/24 08:54:16  sean
// Added closest face capability.
//
// Revision 1.1  1999/11/28 06:25:13  sean
// Split code for classes into .h, .ipp and .cc files.
//

#if !defined(__Edge_inl__)
#error This file is an implementation detail of the class Edge
#endif

// Inline method definitions

//----------------------------Accessors------------------------------------

inline
const Point&
Edge::source( void ) const
{
  return _source;
}

inline
const Point& 
Edge::target( void ) const
{
  return _target;
}

inline
const Point&
Edge::left_face_normal( void ) const
{
  return _left_face_normal;
}

inline
const Point&
Edge::right_face_normal( void ) const
{
  return _right_face_normal;
}

inline
const Point&
Edge::left_side_normal( void ) const
{
  return _left_side_normal;
}

inline
const Point&
Edge::right_side_normal( void ) const
{
  return _right_side_normal;
}

inline
int 
Edge::sign_distance( void ) const
{
  return _sign_distance;
}

inline
int 
Edge::adjacent_face_index( void ) const
{
  return _adjacent_face_index;
}


//
// End of file
