// -*- C++ -*-
//----------------------------------------------------------------------
//
//                            Sean Mauch
//                California Institute of Technology
//                   (C) 1999 All Rights Reserved
//
//----------------------------------------------------------------------

// $Log: Edge.h,v $
// Revision 1.6  2000/09/17 08:22:19  sean
// Added the gradient of the distance to the computed arrays.
//
// Revision 1.5  2000/06/26 08:24:31  sean
// Now return const references instead of objects for accessors.
//
// Revision 1.4  2000/03/20 16:00:53  sean
// *** empty log message ***
//
// Revision 1.3  2000/03/09 11:10:12  sean
// Took out inside Polyhedron checking to speed up.
//
// Revision 1.2  2000/02/24 08:54:16  sean
// Added closest face capability.
//
// Revision 1.1  1999/11/28 06:25:13  sean
// Split code for classes into .h, .ipp and .cc files.
//

#if !defined(__Edge_h__)
#define __Edge_h__

#include "cpt_defs.h"

#include "Point.h"

#include <cstdlib>

using namespace std;

class Edge
{
public:

  Edge();
  Edge ( const Point& source, const Point& target, 
         const Point& left_normal, const Point& right_normal, const int );
  Edge( const Edge& rhs );
  const Edge& operator=( const Edge& rhs );
  void make ( const Point& source, const Point& target, 
              const Point& left_normal, const Point& right_normal, const int );
  
  virtual ~Edge();
  
  //----------------------------Accessors------------------------------------
  const Point& source( void ) const;
  const Point& target( void ) const;
  const Point& left_face_normal( void ) const;
  const Point& right_face_normal( void ) const;
  const Point& left_side_normal( void ) const;
  const Point& right_side_normal( void ) const;
  int sign_distance( void ) const;
  int adjacent_face_index( void ) const;

  //----------------------Mathematical operations-----------------------------
  Real distance( const Point& ) const;
  Real closest_point( const Point&, Point& ) const;
  int distance( const Point&, Real& ) const;
  int closest_point( const Point&, Real&, Point& ) const;
  Point grad_distance( const Point& closest_pt, const Point& cart_pt ) const;

protected:
  
private:

  // The two points that make up the edge.
  Point _source, _target;

  // The length of the edge.
  Real _length;

  // The tangent to the edge.
  Point _tangent;
  
  // The normals to the neighboring faces.
  Point _left_face_normal, _right_face_normal;

  // The points that are closest to the edge lie in a wedge.
  // The normals to the lateral sides of the wedge.
  Point _left_side_normal, _right_side_normal;

  // The index of an adjacent face.
  int _adjacent_face_index;

  // The sign of the distance.
  int _sign_distance;

  void copy( const Edge& e );

};

#define __Edge_inl__
#include "Edge.inl"
#undef __Edge_inl__

#endif

//
// End of file
