// -*- C++ -*-
//----------------------------------------------------------------------
//
//                            Sean Mauch
//                California Institute of Technology
//                   (C) 1999 All Rights Reserved
//
//----------------------------------------------------------------------

// $Log: CyclicIndex.ipp,v $
// Revision 1.1  1999/11/28 06:25:13  sean
// Split code for classes into .h, .ipp and .cc files.
//

#if !defined(__CyclicIndex_inl__)
#error This file is an implementation detail of the class CyclicIndex
#endif

// Inline method definitions

//--------------------------------Accesors----------------------------------

inline
int 
CyclicIndex::operator () ( void ) const {
  return _ind;
}

inline
void 
CyclicIndex::set ( int i ) {
  if ( i < 0 )
    i += _num * ( - i / _num + 1 );
  _ind = i % _num;
}

inline
void 
CyclicIndex::increment ( void ) {
  _ind = ( _ind + 1 ) % _num;
}

inline
void 
CyclicIndex::decrement ( void ) {
  _ind = ( _ind + _num - 1 ) % _num;
}

inline
void 
CyclicIndex::increment_num ( void ) {
  ++_num;
}

inline
void 
CyclicIndex::decrement_num ( void ) {
  --_num;
}


inline
CyclicIndex&
operator ++ ( CyclicIndex& ci )
{
  ci.increment();
  return ci;
}

inline
CyclicIndex&
operator -- ( CyclicIndex& ci )
{
  ci.decrement();
  return ci;
}

//
// End of file
