// -*- C++ -*-
//----------------------------------------------------------------------
//
//                            Sean Mauch
//                California Institute of Technology
//                   (C) 1999 All Rights Reserved
//
//----------------------------------------------------------------------

// $Log: CyclicIndex.h,v $
// Revision 1.2  2000/03/20 16:00:53  sean
// *** empty log message ***
//
// Revision 1.1  1999/11/28 06:25:13  sean
// Split code for classes into .h, .ipp and .cc files.
//

#if !defined(__CyclicIndex_h__)
#define __CyclicIndex_h__

#include "cpt_defs.h"

class CyclicIndex
{
public:

  CyclicIndex();
  CyclicIndex( int n );
  CyclicIndex(const CyclicIndex& rhs);
  const CyclicIndex& operator=(const CyclicIndex& rhs);
  
  virtual ~CyclicIndex();

  //--------------------------------Accesors----------------------------------
  int operator () ( void ) const;
  void set ( int i );
  void increment ( void );
  void decrement ( void );
  void increment_num ( void );
  void decrement_num ( void );
  
protected:
  
private:

  int _ind, _num;
  
  void copy( const CyclicIndex& ci );
};

//--------------------------Increment and Decrement-------------------------
CyclicIndex& operator ++ ( CyclicIndex& ci );
CyclicIndex& operator -- ( CyclicIndex& ci );


#define __CyclicIndex_inl__
#include "CyclicIndex.inl"
#undef __CyclicIndex_inl__

#endif

//
// End of file
