// -*- C++ -*-
//----------------------------------------------------------------------
//
//                            Sean Mauch
//                California Institute of Technology
//                   (C) 1999 All Rights Reserved
//
//----------------------------------------------------------------------

// $Log: Coord.h,v $
// Revision 1.4  2000/08/01 17:31:58  sean
// Added int& accessors.
//
// Revision 1.3  2000/04/05 21:33:12  sean
// Changed iostream.h to iostream.
//
// Revision 1.2  2000/03/20 16:00:53  sean
// *** empty log message ***
//
// Revision 1.1  1999/11/28 06:25:13  sean
// Split code for classes into .h, .ipp and .cc files.
//

#if !defined(__Coord_h__)
#define __Coord_h__

#include "cpt_defs.h"

#include <iosfwd>

class Coord
{
public:

  Coord();
  Coord( int x, int y, int z );
  Coord(const Coord& rhs);
  const Coord& operator=(const Coord& rhs);
  
  virtual ~Coord();

  //---------------------------------Accesors---------------------------------
  int x() const;
  int y() const;
  int z() const;
  int& x();
  int& y();
  int& z();
  
protected:
  
private:

  int _x, _y, _z;
  
  void copy ( const Coord& c );
};

int operator == ( const Coord& a, const Coord& b );
//istream& operator >> ( istream& in, Coord& c );
//ostream& operator << ( ostream& out, const Coord& c );


#define __Coord_inl__
#include "Coord.inl"
#undef __Coord_inl__

#endif

//
// End of file
