// -*- C++ -*-
//----------------------------------------------------------------------
//
//                            Sean Mauch
//                California Institute of Technology
//                   (C) 1999 All Rights Reserved
//
//----------------------------------------------------------------------

// $Log: CPTState.ipp,v $
// Revision 1.7  2001/01/08 22:08:51  sean
// Added cpt_computed variable.
//
// Revision 1.6  2001/01/07 03:15:51  sean
// Made HUGE stand for unknown.
//
// Revision 1.5  2000/09/17 08:22:19  sean
// Added the gradient of the distance to the computed arrays.
//
// Revision 1.4  2000/04/05 11:18:22  sean
// Added write().  Changed infinity.
//
// Revision 1.3  2000/03/20 16:00:53  sean
// *** empty log message ***
//
// Revision 1.2  2000/02/24 08:52:40  sean
// Added closest face capability.
//
// Revision 1.1  1999/12/01 23:28:40  sean
// Original source.
//

#if !defined(__CPTState_inl__)
#error This file is an implementation detail of the class CPTState
#endif

// Inline method definitions

//------------------------Accessors-----------------------------------------

inline
int&
CPTState::parameters_initialized( void )
{
  return _parameters_initialized;
}

inline
int&
CPTState::grid_initialized( void )
{
  return _grid_initialized;
}

inline
int&
CPTState::brep_initialized( void )
{
  return _brep_initialized;
}

inline
int&
CPTState::cpt_computed( void )
{
  return _cpt_computed;
}

inline
Real* 
CPTState::cartesian_domain( void )
{
  return _cartesian_domain;
}

inline
Real& 
CPTState::max_distance( void )
{
  return _max_distance;
}

inline
Real*& 
CPTState::distance( void )
{
  return _distance;
}

inline
Real*& 
CPTState::grad_distance( void )
{
  return _grad_distance;
}

inline
Real*& 
CPTState::closest_point( void )
{
  return _closest_point;
}

inline
int*& 
CPTState::closest_face( void )
{
  return _closest_face;
}

inline
Grid& 
CPTState::grid( void )
{
  return _grid;
}
 
inline
BRep& 
CPTState::brep( void )
{
  return _brep;
}
 

//
// End of file
