// -*- C++ -*-
//----------------------------------------------------------------------
//
//                            Sean Mauch
//                California Institute of Technology
//                   (C) 1999 All Rights Reserved
//
//----------------------------------------------------------------------

// $Log: CPTState.h,v $
// Revision 1.8  2001/01/08 22:08:51  sean
// Added cpt_computed variable.
//
// Revision 1.7  2001/01/07 03:15:51  sean
// Made HUGE stand for unknown.
//
// Revision 1.6  2000/09/17 08:22:19  sean
// Added the gradient of the distance to the computed arrays.
//
// Revision 1.5  2000/04/18 07:31:09  sean
// Added write_grid() and write_mesh().
//
// Revision 1.4  2000/04/05 11:18:22  sean
// Added write().  Changed infinity.
//
// Revision 1.3  2000/03/20 16:00:53  sean
// *** empty log message ***
//
// Revision 1.2  2000/02/24 08:52:40  sean
// Added closest face capability.
//
// Revision 1.1  1999/12/01 23:28:40  sean
// Original source.
//

#if !defined(__CPTState_h__)
#define __CPTState_h__

#include "cpt_defs.h"

#include "Grid.h"
#include "BRep.h"

using namespace std;

// CPTState is an abstract class.  No variables of type CPTState can be 
// created.
class CPTState
{
public:

  virtual void this_makes_the_class_abstract( void ) = 0;

  // No need for constructors or destructors.
  
  static void write_grid( void );

  // commented out by LHK(04/20/2001)
  //static void write_brep( void );

  static void write( void );

  //------------------------Accessors-----------------------------------------
  static int&   parameters_initialized( void );
  static int&   grid_initialized( void );
  static int&   brep_initialized( void );
  static int&   cpt_computed( void );
  static Real*  cartesian_domain( void );
  static Real&  max_distance( void );
  static Real*& distance( void );
  static Real*& grad_distance( void );
  static Real*& closest_point( void );
  static int*&  closest_face( void );
  static Grid&  grid( void );
  static BRep&  brep( void );
  
protected:
  
private:

  static int   _parameters_initialized;
  static int   _grid_initialized;
  static int   _brep_initialized;
  static int   _cpt_computed;
  static Real  _cartesian_domain[6];
  static Real  _max_distance;
  static Real* _distance;
  static Real* _grad_distance;
  static Real* _closest_point;
  static int*  _closest_face;
  static Grid  _grid;
  static BRep  _brep;

};

#define __CPTState_inl__
#include "CPTState.inl"
#undef __CPTState_inl__

#endif

//
// End of file
