// -*- C++ -*-
//----------------------------------------------------------------------
//
//                            Sean Mauch
//                California Institute of Technology
//                   (C) 1999 All Rights Reserved
//
//----------------------------------------------------------------------

// $Log: BRep.ipp,v $
// Revision 1.6  2001/01/07 03:15:51  sean
// Made HUGE stand for unknown.
//
// Revision 1.5  2000/07/12 00:24:35  sean
// Added face_id to fix wrong face index.
//
// Revision 1.4  2000/06/26 08:24:31  sean
// Now return const references instead of objects for accessors.
//
// Revision 1.3  2000/03/08 14:28:03  sean
// Change constructor to a linear time algorithm.
//
// Revision 1.2  2000/02/24 08:50:57  sean
// Added closest face capability.
//
// Revision 1.1  1999/11/28 06:25:13  sean
// Split code for classes into .h, .ipp and .cc files.
//

#if !defined(__BRep_inl__)
#error This file is an implementation detail of the class BRep
#endif

// Inline method definitions

//-----------------------------Accesors-------------------------------------

inline
int 
BRep::num_vertices ( void ) const
{
  return _vertices.end() - _vertices.begin();
}

inline
int 
BRep::num_half_edges ( void ) const
{
  return _half_edges.end() - _half_edges.begin();
}

inline
int 
BRep::num_edges ( void ) const
{
  return ( _half_edges.end() - _half_edges.begin() ) / 2;
}

inline
int 
BRep::num_faces ( void ) const
{
  return _faces.end() - _faces.begin();
}

inline
int 
BRep::num_face_id ( void ) const
{
  return _num_face_id;
}

inline
const Point& 
BRep::vertex( int index ) const
{
  return _vertices[ index ];
}

inline
int 
BRep::adjacent_edge( int index ) const
{
  return _adjacent_edges[ index ];
}

inline
vector<int>& 
BRep::edge_list( int index )
{
  return (*_edge_list)[ index ];
}

inline
const Double<int>&
BRep::half_edge( int index ) const
{
  return _half_edges[ index ];
}

inline
int 
BRep::adjacent_face( int index ) const
{
  return _adjacent_faces[ index ];
}

inline
const Triple<int>& 
BRep::face( int index ) const
{
  return _faces[ index ];
}

inline
const Point& 
BRep::face_normal( int index ) const
{
  return _face_normals[ index ];
}

inline
int 
BRep::edge_adjacent_face_index( const int edge_index ) const
{
  return _adjacent_faces[ 2 * edge_index ];
}

inline
int 
BRep::face_id( int index ) const
{
  return _face_id[ index ];
}

//
// End of file
