// -*- C++ -*-
//----------------------------------------------------------------------
//
//                            Sean Mauch
//                California Institute of Technology
//                   (C) 1999 All Rights Reserved
//
//----------------------------------------------------------------------

// $Log: BBox.h,v $
// Revision 1.7  2000/07/28 19:33:30  sean
// Moved includes from .h to .cc
//
// Revision 1.6  2000/06/16 22:18:22  sean
// Moved some includes from BBox.h to BBox.cc.
//
// Revision 1.5  2000/04/19 17:50:07  sean
// Added intersect().
//
// Revision 1.4  2000/04/05 21:33:12  sean
// Changed iostream.h to iostream.
//
// Revision 1.3  2000/04/05 11:10:51  sean
// Added constructors for vertices, edges and faces.
//
// Revision 1.2  2000/03/20 15:58:26  sean
// *** empty log message ***
//
// Revision 1.1  1999/11/28 06:25:12  sean
// Split code for classes into .h, .ipp and .cc files.
//

#if !defined(__BBox_h__)
#define __BBox_h__

#include "cpt_defs.h"

#include <iosfwd>
#include <vector>
#include <algorithm>

#include "Point.h"
#include "Segment.h"
#include "Coord.h"

class Vertex;
class Edge;
class Face;
class Grid;

using namespace std;


class BBox
{
public:

  BBox();
  BBox ( Real x1, Real y1, Real z1, Real x2, Real y2, Real z2 );
  BBox ( const Segment& s );
  BBox ( const Vertex& v, const Real dist );
  BBox ( const Edge& e, const Real dist );
  BBox ( const Face& f, const Real dist );
  BBox ( const Point& a, const Point& b, const Point& c );
  BBox ( const vector<Point>& );
  BBox ( const vector<Segment>& );
  BBox(const BBox& rhs);
  const BBox& operator=(const BBox& rhs);
  
  virtual ~BBox();

  //----------------------------------Accessors-------------------------------
  const Point& min_point( void ) const;
  const Point& max_point( void ) const;
  Point& min_point( void );
  Point& max_point( void );

  //--------------------------Mathematical Member Functions-------------------
  int inside( const Point& p ) const;
  int scan_convert( vector<Coord>&, const Grid& );

  //---------------------------Friends---------------------------------------
  friend int intersect_xy( const BBox& a, const BBox& b );
  friend int intersect_xz( const BBox& a, const BBox& b );
  friend int intersect_yz( const BBox& a, const BBox& b );

protected:
  
private:

  Point _min, _max;

  void copy( const BBox& b );
  void add_point ( const Point& );
  int inside_xy( const Point& p ) const;
  int inside_xz( const Point& p ) const;
  int inside_yz( const Point& p ) const;

};

//--------------------------Mathematical Functions---------------------------
int intersect( const BBox& a, const BBox& b );

//--------------------File IO------------------------------------------------
//ostream& operator << ( ostream& out, const BBox& bbox );


#define __BBox_inl__
#include "BBox.inl"
#undef __BBox_inl__

#endif

//
// End of file
