///////////////////////////////////////////////////////////////////////////
//                                                                       //
//  File: Utils3d.h                                                      //
//                                                                       //
//  Utility functions for 3D.                                            //
//                                                                       //
///////////////////////////////////////////////////////////////////////////

#ifndef _UTILS_3D_
#define _UTILS_3D_

#include "Base3d.h"

// Rounding
int round(double x);

// Convenience functions for vectors
inline float     Dot(const CVector3d& u, const CVector3d& v)
   { return u.Dot(v); }
inline float     Dot(const CVector3d* pU, const CVector3d* pV)
   { return pU->Dot(pV); }
inline CVector3d Cross(const CVector3d& u, const CVector3d& v)
   { return u.Cross(v); }
inline CVector3d Cross(const CVector3d* pU, const CVector3d* pV)
   { return pU->Cross(pV); }


// Angle between faces
double SinAngle(CFace3d *pFace1,CFace3d *pFace2);
double CosAngle(CFace3d *pFace1,CFace3d *pFace2);
double Angle(CFace3d *pFace1,CFace3d *pFace2);
double Angle(CVector3d *pU,CVector3d *pV);
int    MaxAngleBetweenFaces(CArray3d<CFace3d> &array,double *pMax);

// Distance
double DistanceSquare(CVertex3d *pVertex1,CVertex3d *pVertex2);
double Distance(CVertex3d *pVertex1,CVertex3d *pVertex2);
double SquareDistanceVertexToFace(CVertex3d *pVertex,CFace3d *pFace,CVertex3d *pVertexProjected);

// Operators on vectors
int OppositeSignPerCoord(CVector3d *pV1,CVector3d *pV2);

int PlaneEquationFromFace(CFace3d *pFace, float *a, float *b, float *c, float *d);

// Vertex / faces
int IsVertexInFace(CVertex3d *pVertex,CFace3d *pFace);

// Faces
int AddFaceNoDuplicate(CArray3d<CFace3d> &array,CFace3d *pFace);
int AddFaceRecursive(CArray3d<CFace3d> &array,CFace3d *pFace,CVertex3d *pVertex);

// Sharp edges
int NumSharpEdges(CArray3d<CFace3d> &array,double threshold);

// Plane
int PlaneEquation(CFace3d *pFace,float *a,float *b,float *c,float *d);

// Vertex / segment
int VertexOnSegment(CVertex3d *pVertex,CVertex3d *pV1,CVertex3d *pV2);

// Projection
int ProjectPointOnPlane(CVertex3d *pVertex,CVertex3d *pVertexProjected,float a,float b,float c,float d);
int ProjectPointOnFace(CVertex3d *pVertex,CFace3d *pFace,CVertex3d *pVertexProjected);
int ProjectVertexOnLine(CVertex3d *pVertex,CVertex3d *pVa,CVertex3d *pVb,CVertex3d *pVertexProjected);

// Spring
float Spring(CVertex3d *pVertex,float k);

// Area
double Area(CVertex3d *pV0,CVertex3d *pV1,CVertex3d *pV2);
double FormFunction(CVertex3d *pV0,CVertex3d *pV1,CVertex3d *pV2,CVertex3d *pV3);
double GetMeanArea(CArray3d<CFace3d> *pArrayFace);
double GetMaxArea(CArray3d<CFace3d> *pArrayFace);
double GetMinArea(CArray3d<CFace3d> *pArrayFace);


// Intersections
int IntersectionLineFace(CVertex3d *pV0,CVertex3d *pV1,CFace3d *pFace,CVertex3d *pVertexResult);
int IntersectionLineFaceRecursive(CVertex3d *pV0,CVertex3d *pV1,CFace3d *pFaceStart,CVertex3d *pVertexResult,
				  CFace3d **ppFaceResult,CArray3d<CFace3d> *pArrayFace,int MaxNbFace);
int NearestIntersectionWithLine(CVertex3d *pV0,CVertex3d *pV1,CFace3d *pFaceStart,
				CVertex3d *pVertexResult,CFace3d **ppFaceResult,int MaxNbFace);
int NearestIntersectionWithLine(CArray3d<CFace3d> *pArrayFace,CVertex3d *pV0,CVertex3d *pV1,
				CVertex3d *pVertexResult,CFace3d **ppFaceResult,int *pNbVisitedFace);
int NearestIntersectionWithLineFromFaceAndNeighbors(CFace3d *pFace,CVertex3d *pV0,CVertex3d *pV1,
						    CVertex3d *pVertexResult,CFace3d **ppFaceResult);

int IntersectPlane(CVector3d& rayStart, CVector3d& rayDir,
				   CVector3d& planeNorm, float d,
				   CVector3d& result);
int InsideSphere();
int InsideBox();


int GravityCenter(CArray3d<CVertex3d> *pArray,CVertex3d *pVertexCenter);


#endif // _UTILS_3D_
