///////////////////////////////////////////////////////////////////////////
//                                                                       //
//  Class: CTransform                                                    //
//                                                                       //
//  Transformation class representing scales, rotations and tranlations. //
//                                                                       //
///////////////////////////////////////////////////////////////////////////

#ifndef _TRANSFORM_
#define _TRANSFORM_

#include "Matrix44.h"
#include "Vector3d.h"

class CTransform
{

private :

  // Datas
  CVector3d m_Scale;
  CVector3d m_RotationAxis;
  CVector3d m_Translation;
  float     m_RotationAngle; // in radians

public :

  // Constructor
  CTransform()                     { Clear(); }
  CTransform(const CTransform& t)  { Set(t); }
  CTransform(const CTransform *pT) { Set(pT); }

  virtual ~CTransform() { }

  // Data setting
  void Clear();
  void Set(const CTransform& t);
  void Set(const CTransform *pT);

  void SetScale(const CVector3d &vector)        { m_Scale.Set(vector); }
  void SetRotationAxis(const CVector3d &vector) { m_RotationAxis.Set(vector); }
  void SetTranslation(const CVector3d &vector)  { m_Translation.Set(vector); }
  void SetRotationAngle(const float value)      { m_RotationAngle = value; }

  void SetScale(const CVector3d *pVector)        { m_Scale.Set(pVector); }
  void SetRotationAxis(const CVector3d *pVector) { m_RotationAxis.Set(pVector); }
  void SetTranslation(const CVector3d *pVector)  { m_Translation.Set(pVector); }

  // Data access
  const CVector3d* GetScale()         const { return &m_Scale; }
  const CVector3d* GetRotationAxis()  const { return &m_RotationAxis; }
  const CVector3d* GetTranslation()   const { return &m_Translation; }
  float            GetRotationAngle() const { return m_RotationAngle; }

  CMatrix44 GetMatrix() const;

  void glDraw() const;
};

#endif // _TRANSFORM_

