// SparseMatrix.h: interface for the CSparseMatrix class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SPARSEMATRIX_H__09457841_9D71_11D4_BD4E_0020780050E8__INCLUDED_)
#define AFX_SPARSEMATRIX_H__09457841_9D71_11D4_BD4E_0020780050E8__INCLUDED_


#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Vector3d.h"
#include "Vector2d.h"

#include <stdio.h>

//User-defined tolerancy
#define TOL 0.0005

class CMatrixElement 
{
public:
	int i;
	int j;
	float value;
	CMatrixElement *rowNext;
	CMatrixElement *colNext;

	CMatrixElement(int newi=0, int newj=0, float newValue=0.0)
	{
		i = newi;
		j = newj;
		value = newValue;
		rowNext = colNext = NULL;
    }

	virtual ~CMatrixElement() { if (rowNext != NULL) delete rowNext; }
};

class CSparseMatrix  
{
private:
	
    int numRows;
	int numCols;
	CMatrixElement* *rowList;
	CMatrixElement* *colList;
	float* diagonal;
 
	void Cleanup();
	void cleanup(); //for SparseMatrix_before.cpp
 
public:
	CSparseMatrix();
	CSparseMatrix(int nRows, int numEl, int i[], int j[], float vals[]);
	CSparseMatrix(int nRows);
	CSparseMatrix(int nRows, int nCols);
	virtual ~CSparseMatrix();

	void setDimensions(int nRows);
	void setDimensions(int nRows, int nCols);
	void set1Value(int i, int j, float val);
	void add1Value(int i, int j, float val);
	void setValues(int numEl, int i[], int j[], float valus[]);
	void setRow(int i, CMatrixElement* head);

	CMatrixElement* GetElement(int i, int j);
	float GetValue(int i, int j);
	float diagonalElement(int i);
	void  Print();
	void  PrintMathematica(FILE *fp);

	void multMatVec(float *src, float *dest);
	void multTransMatVec(float *src, float *dest);
	void multMatVec(CVector2d *src, CVector2d *dest);
	void multTransMatVec(CVector2d *src, CVector2d *dest);
	void multTransMatMat();
	void AddMatrix(CSparseMatrix *mat);
	void ScaleRow(int i, float s);

	float OneBiConjugateGradient(float x[], float b[], float minmag_Residual); 
	void BiConjugateGradient(float x[], float b[], float tol=TOL);
	void BiConjugateGradient(CVector2d x[], CVector2d b[], float tol=TOL);
	void preconditionedBiConjugateGradient(float x[], float b[], float tol = TOL);
	void preconditionedBiConjugateGradient(CVector2d x[], CVector2d b[], float tol=TOL);
	
	
	void Debug();
};

void PrintVectorMathematica(FILE *fp, float     theVec[], int n);
void PrintVectorMathematica(FILE *fp, CVector2d theVec[], int n);
void PrintVectorMathematica(FILE *fp, CVector3d theVec[], int n);

#endif // !defined(AFX_SPARSEMATRIX_H__09457841_9D71_11D4_BD4E_0020780050E8__INCLUDED_)
