//********************************************
// PointManip.h
//********************************************
// mmeyer@gg.caltech.edu
// Created :  05/06/00
// Modified : 05/06/00
//********************************************

#ifndef _POINT_MANIP_
#define _POINT_MANIP_

#include "Object3d.h"
#include "Vector3d.h"

#define POINT_MANIP_NO_MOTION    0
#define POINT_MANIP_ROTATE       1
#define POINT_MANIP_TRANSLATE_XY 2
#define POINT_MANIP_TRANSLATE_Z  3

class CPointManip : public CObject3d
{

private :

  // Data
  CVector3d   m_VecDown;
  CVector3d   m_Position;
  int         m_Dragging;
  int         m_Mode;

public :

  CPointManip() { m_Position.Set(0.f,0.f,0.f); 
                  m_Dragging = 0; m_Mode = POINT_MANIP_NO_MOTION; }
  virtual ~CPointManip();

  // Constructors
  CPointManip(const float x, const float y, const float z);
  CPointManip(CVector3d pos);
  CPointManip(CPointManip &pointManip);
  CPointManip(CPointManip *pPointManip);

  // Debug
  void Trace();

  // Data setting
  virtual int GetType();
  void Clear();
  void Set(const float x, const float y, const float z);
  void Set(CVector3d pos);
  void Set(CPointManip &pointManip);
  void Set(CPointManip *pPointManip);
  void Copy(CPointManip &pointManip);
  void Copy(CPointManip *pPointManip);

  void SetMode(int mode) { m_Mode = mode; }
  int  GetMode()         { return m_Mode; }

  void      SetPosition(const float x, const float y, const float z);
  void      SetPosition(CVector3d pos);
  CVector3d GetPosition() { return m_Position; }

  void BeginDrag(CVector3d& currentVec);
  void EndDrag(CVector3d& currentVec);
  void Motion(CVector3d& currentVec);
  int  glDraw();

  int IntersectPlane(CVector3d& rayStart, CVector3d& rayDir, 
		     CVector3d& result, int whichPlane = 2);
  int Intersect(CVector3d& rayStart, CVector3d& rayDir, CVector3d& result);
};


#endif // _POINT_MANIP_
