///////////////////////////////////////////////////////////////////////////
//                                                                       //
//  Class: CParser                                                       //
//                                                                       //
//  Class encapsulating useful parsing functions.                        //
//                                                                       //
///////////////////////////////////////////////////////////////////////////

#ifndef PARSER_H
#define PARSER_H

#include <stdio.h>

class CParser {
 public:
  CParser();
  ~CParser();

  static char  GetChar(FILE *fp);
  static int   GetInt(FILE *fp);
  static float GetFloat(FILE *fp);
  static char* GetWord(FILE *fp);
  static char* GetNext(FILE *fp, char* wordToFind);
  static char* GetNext(FILE *fp, char* wordToFind[], int numWords);
  static char* GetLine(FILE *fp);

  static int   CheckChar(FILE *fp, char c);
  static int   CheckWord(FILE *fp, char *s);
  static int   CheckLine(FILE *fp, char *s);

  static char  tempString[256];

 private:
};

#endif // PARSER_H
