///////////////////////////////////////////////////////////////////////////
//                                                                       //
//  Class: CMaterial                                                     //
//                                                                       //
//  Material class representing surface reflectance properties.          //
//                                                                       //
///////////////////////////////////////////////////////////////////////////

#ifndef _MATERIAL_
#define _MATERIAL_

#include "Color.h"

class CMaterial
{

private :

  CColor m_Ambient;
  CColor m_Diffuse;
  CColor m_Specular;
  CColor m_Emission;
  float  m_Shininess;
  float  m_Transparency;

public :

  // Constructor
  CMaterial()                    { Clear(); }
  CMaterial(const CMaterial& m)  { Set(m); }
  CMaterial(const CMaterial *pM) { Set(pM); }

  virtual ~CMaterial() { }

  // Data setting
  void Clear();
  void Set(const CMaterial& m);
  void Set(const CMaterial *pM);
  void SetAmbient(float r,float g,float b)  { m_Ambient.Set(r,g,b); }
  void SetAmbient(const CVector3d& a)       { m_Ambient = a; }
  void SetDiffuse(float r,float g,float b)  { m_Diffuse.Set(r,g,b); }
  void SetDiffuse(const CVector3d& d)       { m_Diffuse = d; }
  void SetSpecular(float r,float g,float b) { m_Specular.Set(r,g,b); }
  void SetSpecular(const CVector3d& s)      { m_Specular = s; }
  void SetEmission(float r,float g,float b) { m_Emission.Set(r,g,b); }
  void SetEmission(const CVector3d& e)      { m_Emission = e; }
  void SetShininess(float value)            { m_Shininess = value; }
  void SetTransparency(float value)         { m_Transparency = value; }

  // Data access
  CVector3d GetAmbient()      const { return m_Ambient; }
  CVector3d GetDiffuse()      const { return m_Diffuse; }
  CVector3d GetSpecular()     const { return m_Specular; }
  CVector3d GetEmission()     const { return m_Emission; }
  float     GetShininess()    const { return m_Shininess; }
  float     GetTransparency() const { return m_Transparency; }

  void glDraw() const;
};

#endif // _MATERIAL_
