//********************************************
// Light.h
//********************************************
// mmeyer@gg.caltech.edu
// Created :  05/06/00
// Modified : 05/06/00
//********************************************

#ifndef _LIGHT_
#define _LIGHT_

#include "Vector3d.h"

class CLight
{

private :

  int       m_Id;
  int       m_On;
  float     m_Intensity;
  CVector3d m_Color;
  CVector3d m_Position;

public :

  // Constructor
  CLight(int id = 0);
  ~CLight() {}

  // Data access
  int       GetId()        { return m_Id; }
  int       GetOn()        { return m_On; }
  float     GetIntensity() { return m_Intensity; }
  CVector3d GetColor()     { return m_Color; }
  CVector3d GetPosition()  { return m_Position; }

  // Data setting
  void SetId(int value)                     { m_Id = value; }
  void SetOn(int value)                     { m_On = value; }
  void SetIntensity(float value)            { m_Intensity = value; }
  void SetColor(float r,float g,float b)    { m_Color.Set(r,g,b); }
  void SetColor(CVector3d& c)               { m_Color = c; }
  void SetPosition(float x,float y,float z) { m_Position.Set(x,y,z); }
  void SetPosition(CVector3d& p)            { m_Position = p; }

  // Datas
  void Copy(CLight *pLight);

  void glDraw();
};

#endif // _LIGHT_
