///////////////////////////////////////////////////////////////////////////
//                                                                       //
//  Class: CEdge3d                                                       //
//                                                                       //
//  Edge class containing 2 vertex pointers, 2 face pointers and a flag. //
//                                                                       //
///////////////////////////////////////////////////////////////////////////

#ifndef _EDGE_3D_
#define _EDGE_3D_

#include "Object3d.h"

class CVertex3d;
class CFace3d;

class CEdge3d : public CObject3d
{

private :

  // Geometry
  CVertex3d *m_pVertex0;
  CVertex3d *m_pVertex1;

  CFace3d *m_pFace0;
  CFace3d *m_pFace1;

  // Flag
  char m_Flag;

public :

  // Constructors
  CEdge3d();
  CEdge3d(CVertex3d *pVertex0, CVertex3d *pVertex1);
  CEdge3d(CVertex3d *pVertex0, CVertex3d *pVertex1,
	  CFace3d *pFace0, CFace3d *pFace1);
  CEdge3d(CEdge3d& e)  { Set(e); }
  CEdge3d(CEdge3d *pE) { Set(pE); }

  virtual ~CEdge3d() { }
	
  // Data setting
  virtual int GetType() const;
  void Set(CEdge3d& e);
  void Set(CEdge3d *pE);

  // Vertices
  void Set(CVertex3d *pVertex0, CVertex3d *pVertex1);
  void v0(CVertex3d *pVertex) { m_pVertex0 = pVertex; }
  void v1(CVertex3d *pVertex) { m_pVertex1 = pVertex; }

  void v(int index, CVertex3d *pVertex)
  {
    if(index == 0)
      m_pVertex0 = pVertex;
    else
      m_pVertex1 = pVertex;
  }

  // Faces
  void Set(CFace3d *pFace0, CFace3d *pFace1);
  void f0(CFace3d *pFace) { m_pFace0 = pFace; }
  void f1(CFace3d *pFace) { m_pFace1 = pFace; }
  void f(int index, CFace3d *pFace)
  {
    if(index == 0)
      m_pFace0 = pFace;
    else
      m_pFace1 = pFace;
  }

  // Vertices
  CVertex3d* v0() { return m_pVertex0; }
  CVertex3d* v1() { return m_pVertex1; }
  CVertex3d* v(int index)
    { return ((index == 0) ? m_pVertex0 : m_pVertex1); }
  CVertex3d* GetOtherVertex(CVertex3d *pVertexDiff);

  // Faces
  CFace3d* f0() { return m_pFace0; }
  CFace3d* f1() { return m_pFace1; }
  CFace3d* f(int index)
    { return ((index == 0) ? m_pFace0 : m_pFace1); }

  // Flag
  void SetFlag(char flag) { m_Flag = flag; }
  char GetFlag() const { return m_Flag; }

  // Processing
  int IsSharp(float threshold) const; // threshold : sin(angle)
  int Equal(CEdge3d *pEdge) const;
  //double IsIntersect(CEdge3d *pEdge, double zero=0.0001) ;
  CVertex3d* IsIntersect(CEdge3d *pEdge, double zero=0.00001) ;
  CVertex3d* FindAPoint(double s);
  int IsCollinear(CEdge3d *pEdge, double zero=0.00001);

  // OpenGL
  void glDrawHighlight(unsigned char *color) const;
  void glDrawHighlight(unsigned char *color,
		       unsigned char *colorNeighbor) const;
};

#endif // _EDGE_3D_
