///////////////////////////////////////////////////////////////////////////
//                                                                       //
//  Class: CCurve3d                                                      //
//                                                                       //
//  A curve class representing a 3d curve.       //
//                                                                       //
///////////////////////////////////////////////////////////////////////////

#ifndef _CURVE_3D_
#define _CURVE_3D_

#include "Array3d.h"
#include "Vector3d.h"

class CCurve3d
{

private :

  // Datas
  int numCoarse;
  int numVertices;
  int level;
  CVector3d* vertexArray[1000];
  CVector3d* normalArray[1000];
  CVector3d* curvatureArray[1000];

public :

  // Constructor
  CCurve3d();
  virtual ~CCurve3d();

  void AddVertex(CVector3d *pVector);
  void Subdivide();
  void SubdivideG2();
  void SubdivideL2();
  void CalculateNormals();
  void CalculateCurvatures();
  CVector3d CalculateArc(CVector3d& pi, CVector3d& ni, 
			 CVector3d& p, CVector3d& n);

  int GetNumCoarse()   const { return numCoarse; }
  int GetNumVertices() const { return numVertices; }
  int GetLevel()       const { return level; }
  CVector3d* GetVertex(int i)    { return vertexArray[i]; }
  CVector3d* GetNormal(int i)    { return normalArray[i]; }
  CVector3d* GetCurvature(int i) { return curvatureArray[i]; }

  virtual void glDraw();
};


#endif // _CURVE_3D_
