///////////////////////////////////////////////////////////////////////////
//                                                                       //
//  Class: CColor                                                        //
//                                                                       //
//  Color class to represent rgb colors.  Each component of the color is //
//  stored as a floating point number between 0 and 1.                   //
//                                                                       //
///////////////////////////////////////////////////////////////////////////

#ifndef _COLOR_
#define _COLOR_

#include "Vector3d.h"

class CColor : public CVector3d
{

private :

protected:

public :

  // Constructor
  CColor()                          { }
  CColor(CVector3d theVec)          { Set(theVec); }
  CColor(float r, float g, float b) { Set(r,g,b); }
  CColor(float rgb[3])              { Set(rgb); }

  ~CColor() { }

  // Data setting
  CColor& SetHSV(const float h, const float s, const float v);
  CColor& SetHSV(const float hsv[3])
    { return SetHSV(hsv[0], hsv[1], hsv[2]); }
  CColor& SetPseudoColor(const float i)
    { return SetHSV((2.f/3.f) * i, 0.8f, 1.0f); }

  // Data access
  void    GetHSV(float& hue, float& sat, float& val) const;
  void    GetHSV(float hsv[3]) const
    { GetHSV(hsv[0],hsv[1],hsv[2]); }

  // Data setting
  void r(const float red)   { vec[0] = red; }
  void g(const float green) { vec[1] = green; }
  void b(const float blue)  { vec[2] = blue; }

  // Data access
  float r() const { return vec[0]; }
  float g() const { return vec[1]; }
  float b() const { return vec[2]; }

};

#endif // _COLOR_

