///////////////////////////////////////////////////////////////////////////
//                                                                       //
//  Base3d.h                                                             //
//                                                                       //
//  Includes all 3d lib files and defines necessary symbolic constants.  //
//                                                                       //
///////////////////////////////////////////////////////////////////////////

#ifndef _BASE_3D_
#define _BASE_3D_

// 3d library
#include "Object3d.h"
#include "Vertex3d.h"
#include "Vector3d.h"
#include "Vector2d.h"
#include "Edge3d.h"
#include "Face3d.h"
#include "Mesh3d.h"
#include "Matrix44.h"
#include "Quaternion.h"
#include "Transform.h"
#include "Utils3d.h"

// Standard
#include "Array3d.h"

// Parser
#include "Parser.h"

// Apparence attributes
#include "Color.h"
#include "Material.h"
#include "Texture.h"


// Object types
enum {TYPE_OBJECT3D,
      TYPE_VERTEX3D,
      TYPE_VECTOR3D,
      TYPE_VECTOR2D,
      TYPE_QUATERNION,
      TYPE_FACE3D,
      TYPE_POLYGON3D,
      TYPE_POINT_MANIP,
      TYPE_MESH3D,
      TYPE_MATRIX44,
      TYPE_EDGE3D,
      TYPE_VECTORSET3D,
      TYPE_ARCBALL,
      TYPE_VIEWPORT};

// Normal binding
enum {NORMAL_PER_VERTEX,
      NORMAL_PER_FACE};

enum {COLOR_PER_VERTEX,
      COLOR_PER_FACE};

enum  {POTENTIAL_EDGE_LENGTH,
       POTENTIAL_CURVE,
       POTENTIAL_CURVE_AND_EDGE_LENGTH};

// Misc
#define  MAX_FLOAT		3.4e+38f
#define  MAX_DOUBLE		1.7e+308
#define  PI				3.14159265359

#endif // _BASE_3D_


// ** EOF **
