// ImplicitHapticView.h : interface of the CImplicitHapticView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_IMPLICITHAPTICVIEW_H__BE6F43B4_33B9_11D6_81A8_00C04F609F5D__INCLUDED_)
#define AFX_IMPLICITHAPTICVIEW_H__BE6F43B4_33B9_11D6_81A8_00C04F609F5D__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

// OpenGL
#include <gl\\gl.h>
#include <gl\\glu.h>
#include <gl\\glaux.h>

// for Haptic
#include <gstScene.h>
#include <gstPHANToM.h>
#include <gstSeparator.h>

#include "ugHaptic/ugHapticModel.h"
#include "ugHaptic/ugForceField.h"


class CImplicitHapticView : public CView
{
protected: // create from serialization only
	CImplicitHapticView();
	DECLARE_DYNCREATE(CImplicitHapticView)

// Attributes
public:
	CImplicitHapticDoc* GetDocument();

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CImplicitHapticView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CImplicitHapticView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:


	HGLRC m_hRC;

	// window size
	float  m_Height;
	float  m_Width;

	// Options
	GLenum m_Mode;
	int read_polygon;

	// draw 
    void DrawWithOpenGL();
	void DrawBall();
	
	// potentail 
	int potentialMode;
	int drawPotential;

	// display mesh
	int  meshMode;
	void RenderMesh();

	// tmp
	int m_GLPixelIndex;
	bool SetWindowPixelFormat(HDC hDC);
	bool CreateViewGLContext(HDC hDC);

	// mouse
	bool m_LeftButtonDown;
	bool m_RightButtonDown;

	// haptic setup
	void setupHaptic();

    gstScene myScene;
	ugForceField *myHaptic;
	ugHapticModel *myHModel;


// Generated message map functions
protected:
	//{{AFX_MSG(CImplicitHapticView)
	afx_msg void OnPaint();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnDestroy();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnViewShowimplicitdata();
	afx_msg void OnUpdateViewShowimplicitdata(CCmdUI* pCmdUI);
	afx_msg void OnViewShowmeshdata();
	afx_msg void OnUpdateViewShowmeshdata(CCmdUI* pCmdUI);
	afx_msg void OnFileOpen();
	afx_msg void OnFileOpenimplicitfile();
	afx_msg void OnTextureNotexture();
	afx_msg void OnTextureGaussiannoise();
	afx_msg void OnTextureLatticepattern();
	afx_msg void OnSurfacepropertyFriction00();
	afx_msg void OnSurfacepropertyFriction08();
	afx_msg void OnSurfacepropertyStiffness05();
	afx_msg void OnSurfacepropertyFriction05();
	afx_msg void OnSurfacepropertyStiffness09();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in ImplicitHapticView.cpp
inline CImplicitHapticDoc* CImplicitHapticView::GetDocument()
   { return (CImplicitHapticDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_IMPLICITHAPTICVIEW_H__BE6F43B4_33B9_11D6_81A8_00C04F609F5D__INCLUDED_)
