// ImplicitHapticView.cpp : implementation of the CImplicitHapticView class
//
/*
 * 
 * Author : Laehyun Kim
 *			Computer Science Dept.
 *			University of Southern California
 *
 * Date :	March 2002
 *
 */

#include "stdafx.h"
#include "ImplicitHaptic.h"

#include "ImplicitHapticDoc.h"
#include "ImplicitHapticView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#include <math.h>

#define N_CUBES 150
#define CURSOR_RADIUS 0.03

/////////////////////////////////////////////////////////////////////////////
// CImplicitHapticView

IMPLEMENT_DYNCREATE(CImplicitHapticView, CView)

BEGIN_MESSAGE_MAP(CImplicitHapticView, CView)
	//{{AFX_MSG_MAP(CImplicitHapticView)
	ON_WM_PAINT()
	ON_WM_TIMER()
	ON_WM_SIZE()
	ON_WM_DESTROY()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_RBUTTONDOWN()
	ON_WM_RBUTTONUP()
	ON_WM_CREATE()
	ON_COMMAND(ID_VIEW_SHOWIMPLICITDATA, OnViewShowimplicitdata)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SHOWIMPLICITDATA, OnUpdateViewShowimplicitdata)
	ON_COMMAND(ID_VIEW_SHOWMESHDATA, OnViewShowmeshdata)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SHOWMESHDATA, OnUpdateViewShowmeshdata)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_COMMAND(ID_FILE_OPENIMPLICITFILE, OnFileOpenimplicitfile)
	ON_COMMAND(ID_TEXTURE_NOTEXTURE, OnTextureNotexture)
	ON_COMMAND(ID_TEXTURE_GAUSSIANNOISE, OnTextureGaussiannoise)
	ON_COMMAND(ID_TEXTURE_LATTICEPATTERN, OnTextureLatticepattern)
	ON_COMMAND(ID_SURFACEPROPERTY_FRICTION_00, OnSurfacepropertyFriction00)
	ON_COMMAND(ID_SURFACEPROPERTY_FRICTION_08, OnSurfacepropertyFriction08)
	ON_COMMAND(ID_SURFACEPROPERTY_STIFFNESS_05, OnSurfacepropertyStiffness05)
	ON_COMMAND(ID_SURFACEPROPERTY_FRICTION_0, OnSurfacepropertyFriction05)
	ON_COMMAND(ID_SURFACEPROPERTY_STIFFNESS_08, OnSurfacepropertyStiffness09)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CImplicitHapticView construction/destruction

CImplicitHapticView::CImplicitHapticView()
{
	// TODO: add construction code here

	// potentail 
	potentialMode = 0;
	drawPotential = 1;

	// display mesh
	meshMode = 0;
	read_polygon = 0;

	// mouse
	m_LeftButtonDown = false;
	m_RightButtonDown = false;

}

CImplicitHapticView::~CImplicitHapticView()
{
    // stop the haptic simulation
    myScene.stopServoLoop();

	delete myHaptic;
	delete myHModel;

}

BOOL CImplicitHapticView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CImplicitHapticView drawing

void CImplicitHapticView::OnDraw(CDC* pDC)
{
	CImplicitHapticDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	// TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// CImplicitHapticView diagnostics

#ifdef _DEBUG
void CImplicitHapticView::AssertValid() const
{
	CView::AssertValid();
}

void CImplicitHapticView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CImplicitHapticDoc* CImplicitHapticView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CImplicitHapticDoc)));
	return (CImplicitHapticDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CImplicitHapticView message handlers

void CImplicitHapticView::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Add your message handler code here
	// Model is stored in Document
	CImplicitHapticDoc* pDoc = GetDocument();
	//ASSERT_VALID(pDoc);

	// Useful in multidoc templates
	HWND hWnd = GetSafeHwnd();
	HDC hDC = ::GetDC(hWnd);
	wglMakeCurrent(hDC,m_hRC);

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	if( myHaptic->recoverableError() ) {
		myHaptic->resetErrorValable();
		myScene.stopServoLoop();
		Sleep(10);
		myScene.startServoLoop();
	}

	glPushMatrix();

	myHModel->updateView();
	DrawWithOpenGL();
	DrawBall();

	glPopMatrix();

	// Double buffer
	SwapBuffers(dc.m_ps.hdc);
	glFlush();

	// Release
	::ReleaseDC(hWnd,hDC);
	
	// Do not call CView::OnPaint() for painting messages
}


void CImplicitHapticView::DrawWithOpenGL()
{

	glClearColor(0.1f, 0.3f, 0.5f, 0.0f);  // light blue
	glClear(GL_COLOR_BUFFER_BIT);

	glPushMatrix();

	if( read_polygon ) {

		glPushMatrix();
		myHModel->drawObject();
		glPopMatrix();

	}
	if( potentialMode && drawPotential ) myHModel->drawCPT();

	glPopMatrix();

}

void CImplicitHapticView::DrawBall()
{

    // Phantom callback is used for maintaining the current position of the SCP
    glPushMatrix();

	float fVector[3];
	float tp[3], cp[3];

	// track the current position of the tool tip
	myHaptic->getTooltipPoint( tp[0], tp[1], tp[2] );

	// show the force vector when the tool tip is inside the surface
	if( myHaptic->isContact() ) {

		myHaptic->getContactPoint( cp[0], cp[1], cp[2] );
		myHaptic->getForceVector( fVector[0], fVector[1], fVector[2] );

		glColor3f(0.0, 0.0, 1.0);
		glPushMatrix();

		glLineWidth(4.0);
		glBegin(GL_LINES);
		glVertex3f(tp[0], tp[1],tp[2]);
		glVertex3f(cp[0]+fVector[0], cp[1]+fVector[1], cp[2]+fVector[2]);
		glEnd();

		glPopMatrix();

	}


	// move the virtual proxy to the contact point
	if( myHaptic->isContact() ) 
		glTranslatef(cp[0], cp[1], cp[2]);
	else 
		glTranslatef(tp[0], tp[1], tp[2]);


	// draw the proxy on the surface
	glColor3f(1.0, 1.0, 0.0);
    GLUquadricObj *quadObj = gluNewQuadric ();
    gluQuadricDrawStyle (quadObj, GLU_FILL);
    gluQuadricNormals (quadObj, GLU_SMOOTH);
    gluSphere(quadObj, CURSOR_RADIUS, 10, 10);

    glPopMatrix();

	glLineWidth(1.0);

}


void CImplicitHapticView::setupHaptic()
{ 

	/////////////////////////////////////////////////
	//
	// Haptic Setup
	//
	/////////////////////////////////////////////////
	// Create root separator of scene graph for robot
	gstSeparator *root = new gstSeparator;

    // create the root separator and set it as the root of the scene graph
	myScene.setRoot(root);
	root->setName(gstNodeName("root"));

	// create the new class(ugForceField) for force field
    myHaptic = new ugForceField(1, 500);
    root->addChild(myHaptic);

    // create a PHANToM instance and check to make sure it is valid
	gstPHANToM *myPhantom = new gstPHANToM("Default PHANToM");
    if (!myPhantom || !myPhantom->getValidConstruction()) {
        cerr << "Unable to initialize PHANToM device." << endl;
        exit(-1);
    }

    // add the PHANToM object to the scene
	gstSeparator *phantomSep = new gstSeparator;
	phantomSep->addChild(myPhantom);
	root->addChild(phantomSep);

	// setup Haptic Model
	myHModel = new ugHapticModel(N_CUBES, 2.0);  // grid size, max distance rate

    // start the haptic simulation
    myScene.startServoLoop();

	///////////////////////////////////////////////////
}


int CImplicitHapticView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
	HWND hWnd = GetSafeHwnd();
	HDC hDC = ::GetDC(hWnd);

	if(SetWindowPixelFormat(hDC)==FALSE)
		return 0;
	
	if(CreateViewGLContext(hDC)==FALSE)
		return 0;

	glEnable(GL_DEPTH_TEST);
	glClearColor(0.0, 0.0, 0.0, 1.0f);

	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	glShadeModel (GL_SMOOTH);


	// Lighting
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glEnable(GL_LIGHT0);
	glEnable(GL_LIGHTING);
	float lpos[4] = {0.0, 0.0, N_CUBES, 1.0 };
	glLightfv(GL_LIGHT0,GL_POSITION,lpos);
	// glLightModelf(GL_LIGHT_MODEL_TWO_SIDE, 1.0);

	glColorMaterial(GL_FRONT_AND_BACK,GL_DIFFUSE);
	glEnable(GL_COLOR_MATERIAL);


	// Perspective
	CRect rect;
	GetClientRect(&rect);
	double aspect = (rect.Height() == 0) ? rect.Width() : (double)rect.Width()/(double)rect.Height();

	m_Height = (float)rect.Height();
	m_Width  = (float)rect.Width();

	// set Timer 
	SetTimer (0, 100, NULL);

    // start the haptic simulation
    setupHaptic();

	// initialize view for haptic
	myHModel->initView( rect.Width(),rect.Height() );

	return 0;
}


//********************************************
// SetWindowPixelFormat
//********************************************
bool CImplicitHapticView::SetWindowPixelFormat(HDC hDC)
{
	PIXELFORMATDESCRIPTOR pixelDesc;
	
	pixelDesc.nSize = sizeof(PIXELFORMATDESCRIPTOR);
	pixelDesc.nVersion = 1;
	
	pixelDesc.dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL |
		PFD_DOUBLEBUFFER | PFD_STEREO_DONTCARE;
	
	pixelDesc.iPixelType = PFD_TYPE_RGBA;
	pixelDesc.cColorBits = 32;
	pixelDesc.cRedBits = 8;
	pixelDesc.cRedShift = 16;
	pixelDesc.cGreenBits = 8;
	pixelDesc.cGreenShift = 8;
	pixelDesc.cBlueBits = 8;
	pixelDesc.cBlueShift = 0;
	pixelDesc.cAlphaBits = 0;
	pixelDesc.cAlphaShift = 0;
	pixelDesc.cAccumBits = 64;
	pixelDesc.cAccumRedBits = 16;
	pixelDesc.cAccumGreenBits = 16;
	pixelDesc.cAccumBlueBits = 16;
	pixelDesc.cAccumAlphaBits = 0;
	pixelDesc.cDepthBits = 32;
	pixelDesc.cStencilBits = 8;
	pixelDesc.cAuxBuffers = 0;
	pixelDesc.iLayerType = PFD_MAIN_PLANE;
	pixelDesc.bReserved = 0;
	pixelDesc.dwLayerMask = 0;
	pixelDesc.dwVisibleMask = 0;
	pixelDesc.dwDamageMask = 0;
	
	m_GLPixelIndex = ChoosePixelFormat(hDC,&pixelDesc);
	if(m_GLPixelIndex == 0) // Choose default
	{
		m_GLPixelIndex = 1;
		if(DescribePixelFormat(hDC,m_GLPixelIndex,
			sizeof(PIXELFORMATDESCRIPTOR),&pixelDesc)==0)
			return FALSE;
	}
	
	if(!SetPixelFormat(hDC,m_GLPixelIndex,&pixelDesc))
		return FALSE;

	return TRUE;
}


//********************************************
// CreateViewGLContext
// Create an OpenGL rendering context
//********************************************
bool CImplicitHapticView::CreateViewGLContext(HDC hDC)
{
	m_hRC = wglCreateContext(hDC);

	if(m_hRC==NULL)
		return FALSE;

	if(wglMakeCurrent(hDC,m_hRC)==FALSE)
		return FALSE;

	return TRUE;
}


void CImplicitHapticView::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	InvalidateRect (NULL, FALSE);

	CView::OnTimer(nIDEvent);
}

void CImplicitHapticView::OnSize(UINT nType, int cx, int cy) 
{
	CView::OnSize(nType, cx, cy);
	
	// TODO: Add your message handler code here

	m_Height = (float)cy;
	m_Width  = (float)cx;

	CClientDC clientDC(this);
	wglMakeCurrent(clientDC.m_hDC, m_hRC);

	// Set OpenGL viewport and perspective
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	// resize
	myHModel->onSize(cx, cy);

	wglMakeCurrent(NULL, NULL);	
}


void CImplicitHapticView::OnDestroy() 
{
	CView::OnDestroy();
	
	// TODO: Add your message handler code here

	wglDeleteContext(m_hRC);
	
}



void CImplicitHapticView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	m_LeftButtonDown = true;
	myHModel->handleMouseButton(point.x,point.y, LeftButtonDown);

	CView::OnLButtonDown(nFlags, point);
}

void CImplicitHapticView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	m_LeftButtonDown = false;
	myHModel->handleMouseButton(point.x,point.y, LeftButtonUp);

	CView::OnLButtonUp(nFlags, point);
}

void CImplicitHapticView::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	if(m_LeftButtonDown || m_RightButtonDown)
	{
		// update view position 
		myHModel->mouseMove(point.x,point.y);

		InvalidateRect(NULL,FALSE);
	}	

	CView::OnMouseMove(nFlags, point);
}

void CImplicitHapticView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default

	m_RightButtonDown = true;
	myHModel->handleMouseButton(point.x,point.y, RightButtonDown);
	
	CView::OnRButtonDown(nFlags, point);
}

void CImplicitHapticView::OnRButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	m_RightButtonDown = false;
	myHModel->handleMouseButton(point.x,point.y, RightButtonUp);

	CView::OnRButtonUp(nFlags, point);
}


void CImplicitHapticView::OnFileOpen() 
{
	// TODO: Add your command handler code here

	char *fname;	
	static char BASED_CODE szFilter[] = "Inventor Files(*.iv) | *.iv ||";
	CFileDialog FDlg( TRUE, "iv", "*.iv", OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, szFilter );

	if( FDlg.DoModal() == IDOK )
	{
		//if( read_polygon ) theMesh.Free();

		fname = strdup( FDlg.GetFileName() );

		myHModel->loadIVFile(fname);

		read_polygon = 1;
		InvalidateRect (NULL, FALSE);
	}
	else read_polygon = 0;
	
}

void CImplicitHapticView::OnFileOpenimplicitfile() 
{
	// TODO: Add your command handler code here

	char *fname;	
	static char BASED_CODE szFilter[] = "CPT Files(*.cpt) | *.cpt ||";
	CFileDialog FDlg( TRUE, "cpt", "*.cpt", OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, szFilter );

	if( FDlg.DoModal() == IDOK )
	{
		fname = strdup( FDlg.GetFileName() );

		myHModel->loadCPT(fname);

		potentialMode = 1;
		InvalidateRect (NULL, FALSE);
	}
	else potentialMode = 0;
	
}

void CImplicitHapticView::OnViewShowimplicitdata() 
{
	// TODO: Add your command handler code here
	if( !potentialMode ) return;

	// TODO: Add your command handler code here
	if( drawPotential ) drawPotential = 0;
	else drawPotential = 1;
	
}

void CImplicitHapticView::OnUpdateViewShowimplicitdata(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	if( !potentialMode ) return;

	// TODO: Add your command update UI handler code here
	if( drawPotential ) pCmdUI->SetCheck(TRUE);
	else pCmdUI->SetCheck(FALSE);
	
}

void CImplicitHapticView::OnViewShowmeshdata() 
{
	// TODO: Add your command handler code here
	if( meshMode ) {
		meshMode = 0;
		myHModel->setShowMesh(false);
	}
	else {
		meshMode = 1;
		myHModel->setShowMesh(true);
	}	
}

void CImplicitHapticView::OnUpdateViewShowmeshdata(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	if( meshMode ) pCmdUI->SetCheck(TRUE);
	else pCmdUI->SetCheck(FALSE);
	
}



void CImplicitHapticView::OnTextureNotexture() 
{
	// TODO: Add your command handler code here

	myHModel->setTextureType(NO_TEXTURE);
	
}

void CImplicitHapticView::OnTextureGaussiannoise() 
{
	// TODO: Add your command handler code here

	myHModel->setTextureType(NOISE_TEXTURE);
	
}

void CImplicitHapticView::OnTextureLatticepattern() 
{
	// TODO: Add your command handler code here
	
	myHModel->setTextureType(PATTERN_TEXTURE);

}

void CImplicitHapticView::OnSurfacepropertyFriction00() 
{
	// TODO: Add your command handler code here
	
	myHaptic->setFrictionValue( 0.0 );

}

void CImplicitHapticView::OnSurfacepropertyFriction05() 
{
	// TODO: Add your command handler code here
	
	myHaptic->setFrictionValue( 0.5 );

}

void CImplicitHapticView::OnSurfacepropertyFriction08() 
{
	// TODO: Add your command handler code here
	
	myHaptic->setFrictionValue( 0.8 );

}

void CImplicitHapticView::OnSurfacepropertyStiffness05() 
{
	// TODO: Add your command handler code here

	myHaptic->setStiffness( 0.5 );
	
}


void CImplicitHapticView::OnSurfacepropertyStiffness09() 
{
	// TODO: Add your command handler code here
	
	myHaptic->setStiffness( 0.8 );

}
